<?php

final class ITSEC_Malware_Privacy {
	public function __construct() {
		add_filter( 'itsec_get_privacy_policy_for_sharing', array( $this, 'get_privacy_policy_for_sharing' ) );
	}

	public function get_privacy_policy_for_sharing( $policy ) {
		$suggested_text = '<strong class="privacy-policy-tutorial">' . __( 'Suggested text:' ) . ' </strong>';

		/* Translators: 1: Link to Sucuri's privacy policy */
		$policy .= "<p>$suggested_text " . sprintf( wp_kses( __( 'This site is scanned for potential malware and vulnerabilities by Sucuri\'s SiteCheck. We do not send personal information to Sucuri; however, Sucuri could find personal information posted publicly (such as in comments) during their scan. For more details, please see <a href="%1$s">Sucuri\'s privacy policy</a>.', 'better-wp-security' ), array( 'a' => array( 'href' => array() ) ) ), 'https://sucuri.net/privacy' ) . "</p>\n";

		return $policy;
	}
}
new ITSEC_Malware_Privacy();
