/**
 * WordPress dependencies
 */
import { __, sprintf } from '@wordpress/i18n';
import { Fragment } from '@wordpress/element';

/**
 * Internal dependencies
 */
import { castWPError, isWPError } from '@ithemes/security-utils';
import WPErrorDetails from './wp-error-details';
import SystemErrorDetails from './system-error-details';
import MalwareDetails from './malware-details';
import BlacklistDetails from './blacklist-details';
import './style.scss';

function MalwareScanResults( { results, showErrorDetails = true } ) {
	let siteUrl;

	if ( isWPError( results ) ) {
		const errorData = castWPError( results ).getErrorData();
		siteUrl = ( errorData && errorData.itsec_site ) ? errorData.itsec_site.url : undefined;
	} else if ( results.itsec_site ) {
		siteUrl = results.itsec_site.url;
	}

	return (
		<div className="itsec-malware-scan-results">
			{ siteUrl && <h4>{ sprintf( __( 'Site: %s', 'better-wp-security' ), siteUrl ) }</h4> }

			{ isWPError( results ) ? <WPErrorDetails results={ results } showErrorDetails={ showErrorDetails } /> : (
				<Fragment>
					<SystemErrorDetails results={ results } />
					<MalwareDetails results={ results } />
					<BlacklistDetails results={ results } />
				</Fragment>
			) }
		</div>
	);
}

export default MalwareScanResults;
