<?php
/**
 * Custom Fields
 *
 * @package SimpleMag
 * @since 	SimpleMag 1.1
**/



if(function_exists("register_field_group"))
{
	register_field_group(array (
		'id' => 'acf_category-options',
		'title' => 'Category Options',
		'fields' => array (
			array (
				'key' => 'field_533c147d82c97',
				'label' => 'Category Slider',
				'name' => 'category_slider',
				'type' => 'radio',
				'instructions' => 'Enable or Disable this category slider',
				'choices' => array (
					'cat_slider_on' => 'Enable',
					'cat_slider_off' => 'Disable',
				),
				'other_choice' => 0,
				'save_other_choice' => 0,
				'default_value' => 'cat_slider_off',
				'layout' => 'horizontal',
			),
			array (
				'key' => 'field_533c14bd82c98',
				'label' => 'Slider Position',
				'name' => 'category_slider_position',
				'type' => 'radio',
				'instructions' => 'Place the slider full width or above the content',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_533c147d82c97',
							'operator' => '==',
							'value' => 'cat_slider_on',
						),
					),
					'allorany' => 'all',
				),
				'choices' => array (
					'cat_slider_full' => 'Full Width',
					'cat_slider_above' => 'Above The Content',
				),
				'other_choice' => 0,
				'save_other_choice' => 0,
				'default_value' => 'cat_slider_full',
				'layout' => 'horizontal',
			),
			array (
				'key' => 'field_533c158182c9a',
				'label' => 'Posts Layout',
				'name' => 'category_posts_layout',
				'type' => 'radio',
				'instructions' => 'Select posts layout for this category',
				'choices' => array (
					'masonry-layout' => 'Masonry',
					'grid-layout' => 'Grid',
					'list-layout' => 'List',
					'classic-layout' => 'Classic List',
				),
				'other_choice' => 0,
				'save_other_choice' => 0,
				'default_value' => 'masonry-layout',
				'layout' => 'horizontal',
			),
			array (
				'key' => 'field_533c153682c99',
				'label' => 'Category Sidebar',
				'name' => 'category_sidebar',
				'type' => 'radio',
				'instructions' => 'Enable or Disable the sidebar for this category',
				'choices' => array (
					'cat_sidebar_on' => 'Enable',
					'cat_sidebar_off' => 'DIsable',
				),
				'other_choice' => 0,
				'save_other_choice' => 0,
				'default_value' => 'cat_sidebar_off',
				'layout' => 'horizontal',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'ef_taxonomy',
					'operator' => '==',
					'value' => 'category',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'no_box',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_format-audio',
		'title' => 'Format Audio',
		'fields' => array (
			array (
				'key' => 'field_531c569008bad',
				'label' => 'Add SoundCloud Audio',
				'name' => 'add_audio_url',
				'type' => 'text',
				'instructions' => 'Paste page URL from SoundCloud',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'none',
				'maxlength' => '',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'post',
					'order_no' => 0,
					'group_no' => 0,
				),
				array (
					'param' => 'post_format',
					'operator' => '==',
					'value' => 'audio',
					'order_no' => 1,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_format-gallery',
		'title' => 'Format Gallery',
		'fields' => array (
			array (
				'key' => 'field_531c5627de26a',
				'label' => 'Upload gallery images',
				'name' => 'post_upload_gallery',
				'type' => 'gallery',
				'preview_size' => 'thumbnail',
				'library' => 'all',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'post',
					'order_no' => 0,
					'group_no' => 0,
				),
				array (
					'param' => 'post_format',
					'operator' => '==',
					'value' => 'gallery',
					'order_no' => 1,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_format-video',
		'title' => 'Format Video',
		'fields' => array (
			array (
				'key' => 'field_531c5577c6196',
				'label' => 'Add Video',
				'name' => 'add_video_url',
				'type' => 'text',
				'instructions' => 'Paste video page URL',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'none',
				'maxlength' => '',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'post',
					'order_no' => 0,
					'group_no' => 0,
				),
				array (
					'param' => 'post_format',
					'operator' => '==',
					'value' => 'video',
					'order_no' => 1,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_page-composer',
		'title' => 'Page Composer',
		'fields' => array (
			array (
				'key' => 'field_5313089b1917a',
				'label' => 'Page Composer',
				'name' => 'page_composer',
				'type' => 'flexible_content',
				'layouts' => array (
					array (
						'label' => 'WP Editor',
						'name' => 'wp_section_editor',
						'display' => 'table',
						'min' => '',
						'max' => '',
						'sub_fields' => array (
							array (
								'key' => 'field_536a68e2be4e2',
								'label' => 'Editor',
								'name' => 'wp_ti_editor',
								'type' => 'wp_wysiwyg',
								'column_width' => '',
								'default_value' => '',
								'teeny' => 0,
								'media_buttons' => 1,
								'dfw' => 1,
							),
						),
					),
					array (
						'label' => 'Title/Text',
						'name' => 'title_or_text',
						'display' => 'row',
						'min' => '',
						'max' => '',
						'sub_fields' => array (
							array (
								'key' => 'field_5313193b1917e',
								'label' => 'Title Styling',
								'name' => 'title_styling',
								'type' => 'select',
								'column_width' => '',
								'choices' => array (
									'theme_title' => 'Theme Title',
									'heading_1' => 'Heading 1',
									'heading_2' => 'Heading 2',
									'bold_text' => 'Bold',
									'paragraph_text' => 'Paragraph',
								),
								'default_value' => 'theme_title',
								'allow_null' => 0,
								'multiple' => 0,
							),
							array (
								'key' => 'field_53131a071917f',
								'label' => 'Title Content',
								'name' => 'title_text_content',
								'type' => 'text',
								'conditional_logic' => array (
									'status' => 1,
									'rules' => array (
										array (
											'field' => 'field_5313193b1917e',
											'operator' => '!=',
											'value' => 'paragraph_text',
										),
									),
									'allorany' => 'all',
								),
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'formatting' => 'none',
								'maxlength' => '',
							),
							array (
								'key' => 'field_53131a3819180',
								'label' => 'Paragraph Content',
								'name' => 'title_text_content',
								'type' => 'textarea',
								'conditional_logic' => array (
									'status' => 1,
									'rules' => array (
										array (
											'field' => 'field_5313193b1917e',
											'operator' => '==',
											'value' => 'paragraph_text',
										),
									),
									'allorany' => 'all',
								),
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '',
								'maxlength' => '',
								'rows' => '',
								'formatting' => 'html',
							),
						),
					),
					array (
						'label' => 'Posts Slider',
						'name' => 'hp_posts_slider',
						'display' => 'row',
						'min' => '',
						'max' => 1,
						'sub_fields' => array (
							array (
								'key' => 'field_53ca6b6094985',
								'label' => 'Slider Position',
								'name' => 'posts_slider_position',
								'type' => 'radio',
								'instructions' => 'Select the slider position',
								'column_width' => '',
								'choices' => array (
									'slider_on_page' => 'Where it placed',
									'slider_under_menu' => 'Under the menu',
								),
								'other_choice' => 0,
								'save_other_choice' => 0,
								'default_value' => 'slider_on_page',
								'layout' => 'horizontal',
							),
							array (
								'key' => 'field_531310ee1917b',
								'label' => 'Slider Type',
								'name' => 'posts_slider_type',
								'type' => 'radio',
								'instructions' => 'Select the slider type',
								'column_width' => '',
								'choices' => array (
									'slider_content' => 'Regular',
									'slider_and_latest' => 'With two latest posts',
									'slider_full_width' => 'Full width',
								),
								'other_choice' => 0,
								'save_other_choice' => 0,
								'default_value' => 'slider_content',
								'layout' => 'horizontal',
							),
							array (
								'key' => 'field_53d53d1a2fa79',
								'label' => 'Posts To Show',
								'name' => 'slides_to_show',
								'type' => 'number',
								'instructions' => 'Type the maximum number of posts in the slider',
								'column_width' => '',
								'default_value' => 3,
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'min' => 1,
								'max' => '',
								'step' => 1,
							),
						),
					),
					array (
						'label' => 'Posts Carousel',
						'name' => 'hp_posts_carousel',
						'display' => 'row',
						'min' => '',
						'max' => 1,
						'sub_fields' => array (
							array (
								'key' => 'field_53ca778a8c6f4',
								'label' => 'Carousel Position',
								'name' => 'carousel_position',
								'type' => 'radio',
								'instructions' => 'Select the carousel position',
								'column_width' => '',
								'choices' => array (
									'carousel_on_page' => 'Where it placed',
									'carousel_under_menu' => 'Under the menu',
								),
								'other_choice' => 0,
								'save_other_choice' => 0,
								'default_value' => 'carousel_on_page',
								'layout' => 'horizontal',
							),
							array (
								'key' => 'field_53da5338c99e2',
								'label' => 'Slides To Show',
								'name' => 'carousel_slides_to_show',
								'type' => 'number',
								'instructions' => 'Type the maximum number of posts in the slider',
								'column_width' => '',
								'default_value' => 5,
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'min' => 1,
								'max' => '',
								'step' => 1,
							),
						),
					),
					array (
						'label' => 'Custom Slider',
						'name' => 'custom_slider',
						'display' => 'row',
						'min' => '',
						'max' => '',
						'sub_fields' => array (
							array (
								'key' => 'field_53cfea02b398e',
								'label' => 'Slider Position',
								'name' => 'custom_slider_position',
								'type' => 'radio',
								'column_width' => '',
								'choices' => array (
									'custom_on_page' => 'Where it placed',
									'custom_under_menu' => 'Under the menu',
								),
								'other_choice' => 0,
								'save_other_choice' => 0,
								'default_value' => 'custom_on_page',
								'layout' => 'horizontal',
							),
							array (
								'key' => 'field_53cfedb6b398f',
								'label' => 'Slider Type',
								'name' => 'custom_slider_type',
								'type' => 'radio',
								'column_width' => '',
								'choices' => array (
									'custom_slider_content' => 'Regular',
									'custom_slider_full' => 'Full width',
								),
								'other_choice' => 0,
								'save_other_choice' => 0,
								'default_value' => 'custom_slider_content',
								'layout' => 'horizontal',
							),
							array (
								'key' => 'field_53131b9cd999d',
								'label' => 'Slides',
								'name' => 'custom_add_new_slide',
								'type' => 'repeater',
								'instructions' => 'Leave Button Text empty if you do not want to show the button',
								'column_width' => '',
								'sub_fields' => array (
									array (
										'key' => 'field_53131c3fd999e',
										'label' => 'Slide Image',
										'name' => 'custom_slide_image',
										'type' => 'image',
										'column_width' => '',
										'save_format' => 'id',
										'preview_size' => 'thumbnail',
										'library' => 'all',
									),
									array (
										'key' => 'field_53131c88d999f',
										'label' => 'Slide Title',
										'name' => 'custom_slide_title',
										'type' => 'text',
										'column_width' => '',
										'default_value' => '',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'formatting' => 'none',
										'maxlength' => '',
									),
									array (
										'key' => 'field_53131e39d99a0',
										'label' => 'Button Text',
										'name' => 'custom_button_text',
										'type' => 'text',
										'column_width' => '',
										'default_value' => '',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'formatting' => 'none',
										'maxlength' => '',
									),
									array (
										'key' => 'field_53131e6dd99a2',
										'label' => 'URL',
										'name' => 'custom_slide_url',
										'type' => 'text',
										'column_width' => '',
										'default_value' => '',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'formatting' => 'none',
										'maxlength' => '',
									),
								),
								'row_min' => 1,
								'row_limit' => '',
								'layout' => 'row',
								'button_label' => 'Add Slide',
							),
						),
					),
					array (
						'label' => 'Featured Posts',
						'name' => 'hp_featured_posts',
						'display' => 'row',
						'min' => '',
						'max' => '',
						'sub_fields' => array (
							array (
								'key' => 'field_53131f36381a8',
								'label' => 'Main Title',
								'name' => 'featured_main_title',
								'type' => 'text',
								'instructions' => 'Main title for this section',
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'formatting' => 'none',
								'maxlength' => '',
							),
							array (
								'key' => 'field_53131f64381a9',
								'label' => 'Sub Title',
								'name' => 'featured_sub_title',
								'type' => 'text',
								'instructions' => 'Sub title for this section',
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'formatting' => 'none',
								'maxlength' => '',
							),
							array (
								'key' => 'field_53131f95381aa',
								'label' => 'Posts Excerpt',
								'name' => 'featured_excerpt',
								'type' => 'radio',
								'instructions' => 'Enable or disable the excerpt',
								'column_width' => '',
								'choices' => array (
									'enable' => 'Enable',
									'disable' => 'Disable',
								),
								'other_choice' => 0,
								'save_other_choice' => 0,
								'default_value' => 'enable',
								'layout' => 'horizontal',
							),
							array (
								'key' => 'field_53ad807b2031d',
								'label' => 'Posts Per page',
								'name' => 'featured_posts_per_page',
								'type' => 'number',
								'instructions' => 'How many posts you want to show at once',
								'column_width' => '',
								'default_value' => 3,
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'min' => 2,
								'max' => '',
								'step' => 1,
							),
						),
					),
					array (
						'label' => 'Latest By Category',
						'name' => 'latest_by_category',
						'display' => 'row',
						'min' => '',
						'max' => '',
						'sub_fields' => array (
							array (
								'key' => 'field_53132146a44bc',
								'label' => 'Main Title',
								'name' => 'category_main_title',
								'type' => 'text',
								'instructions' => 'Main title for this section',
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'formatting' => 'none',
								'maxlength' => '',
							),
							array (
								'key' => 'field_53132146a44bd',
								'label' => 'Sub Title',
								'name' => 'category_sub_title',
								'type' => 'text',
								'instructions' => 'Sub title for this section',
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'formatting' => 'none',
								'maxlength' => '',
							),
							array (
								'key' => 'field_531321b5a44c0',
								'label' => 'Category',
								'name' => 'category_section_name',
								'type' => 'taxonomy',
								'instructions' => 'Select the category for this section',
								'column_width' => '',
								'taxonomy' => 'category',
								'field_type' => 'select',
								'allow_null' => 0,
								'load_save_terms' => 0,
								'return_format' => 'id',
								'multiple' => 0,
							),
							array (
								'key' => 'field_53132146a44be',
								'label' => 'Posts Excerpt',
								'name' => 'category_excerpt',
								'type' => 'radio',
								'instructions' => 'Enable or disable the excerpt',
								'column_width' => '',
								'choices' => array (
									'enable' => 'Enable',
									'disable' => 'Disable',
								),
								'other_choice' => 0,
								'save_other_choice' => 0,
								'default_value' => 'enable',
								'layout' => 'horizontal',
							),
							array (
								'key' => 'field_53132146a44bf',
								'label' => 'Posts To Show',
								'name' => 'category_posts_per_page',
								'type' => 'number',
								'instructions' => 'Number of posts to show',
								'column_width' => '',
								'default_value' => 3,
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'min' => 2,
								'max' => '',
								'step' => 1,
							),
							array (
								'key' => 'field_53cfa80b2e571',
								'label' => 'Button',
								'name' => 'category_button',
								'type' => 'radio',
								'instructions' => 'Enable or Disable the section button',
								'column_width' => '',
								'choices' => array (
									'cat_but_enable' => 'Enable',
									'cat_but_disable' => 'Disable',
								),
								'other_choice' => 0,
								'save_other_choice' => 0,
								'default_value' => 'cat_but_enable',
								'layout' => 'horizontal',
							),
						),
					),
					array (
						'label' => 'Latest By Format',
						'name' => 'latest_by_format',
						'display' => 'row',
						'min' => '',
						'max' => '',
						'sub_fields' => array (
							array (
								'key' => 'field_5313226c264a6',
								'label' => 'Main Title',
								'name' => 'format_main_title',
								'type' => 'text',
								'instructions' => 'Main title for this section',
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'formatting' => 'none',
								'maxlength' => '',
							),
							array (
								'key' => 'field_5313226c264a7',
								'label' => 'Sub Title',
								'name' => 'format_sub_title',
								'type' => 'text',
								'instructions' => 'Sub title for this section',
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'formatting' => 'none',
								'maxlength' => '',
							),
							array (
								'key' => 'field_5313226c264a8',
								'label' => 'Format',
								'name' => 'format_section_name',
								'type' => 'select',
								'instructions' => 'Select this section format',
								'column_width' => '',
								'choices' => array (
									'standard' => 'Standard',
									'video' => 'Video',
									'audio' => 'Audio',
									'gallery' => 'Gallery',
								),
								'default_value' => 'standard',
								'allow_null' => 0,
								'multiple' => 0,
							),
							array (
								'key' => 'field_5313226c264aa',
								'label' => 'Posts To Show',
								'name' => 'format_posts_per_page',
								'type' => 'number',
								'instructions' => 'Number of posts to show',
								'column_width' => '',
								'default_value' => 3,
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'min' => 2,
								'max' => '',
								'step' => 1,
							),
							array (
								'key' => 'field_5332d6731ef4f',
								'label' => 'Background Color',
								'name' => 'format_background_color',
								'type' => 'color_picker',
								'instructions' => 'Select section background color',
								'column_width' => '',
								'default_value' => '',
							),
							array (
								'key' => 'field_5332d6971ef50',
								'label' => 'Text Color',
								'name' => 'format_text_color',
								'type' => 'color_picker',
								'instructions' => 'Select section text color',
								'column_width' => '',
								'default_value' => '',
							),
						),
					),
					array (
						'label' => 'Latest Reviews',
						'name' => 'latest_reviews',
						'display' => 'row',
						'min' => '',
						'max' => '',
						'sub_fields' => array (
							array (
								'key' => 'field_53132375264ae',
								'label' => 'Main Title',
								'name' => 'reviews_main_title',
								'type' => 'text',
								'instructions' => 'Main title for this section',
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'formatting' => 'none',
								'maxlength' => '',
							),
							array (
								'key' => 'field_53132375264af',
								'label' => 'Sub Title',
								'name' => 'reviews_sub_title',
								'type' => 'text',
								'instructions' => 'Sub title for this section',
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'formatting' => 'none',
								'maxlength' => '',
							),
							array (
								'key' => 'field_53132375264b1',
								'label' => 'Posts Excerpt',
								'name' => 'reviews_excerpt',
								'type' => 'radio',
								'instructions' => 'Enable or disable the excerpt',
								'column_width' => '',
								'choices' => array (
									'enable' => 'Enable',
									'disable' => 'Disable',
								),
								'other_choice' => 0,
								'save_other_choice' => 0,
								'default_value' => 'enable',
								'layout' => 'horizontal',
							),
							array (
								'key' => 'field_53132375264b2',
								'label' => 'Posts To Show',
								'name' => 'reviews_posts_per_page',
								'type' => 'number',
								'instructions' => 'Number of posts to show',
								'column_width' => '',
								'default_value' => 3,
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'min' => 2,
								'max' => '',
								'step' => 1,
							),
						),
					),
					array (
						'label' => 'Latest Posts',
						'name' => 'latest_posts',
						'display' => 'row',
						'min' => '',
						'max' => '',
						'sub_fields' => array (
							array (
								'key' => 'field_53623e51497e6',
								'label' => 'Main Title',
								'name' => 'latest_main_title',
								'type' => 'text',
								'instructions' => 'Main title for this section',
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'formatting' => 'none',
								'maxlength' => '',
							),
							array (
								'key' => 'field_5314724d31af8',
								'label' => 'Sub Title',
								'name' => 'latest_sub_title',
								'type' => 'text',
								'instructions' => 'Sub title for this section',
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'formatting' => 'none',
								'maxlength' => '',
							),
							array (
								'key' => 'field_5314727f31afb',
								'label' => 'Posts Layout',
								'name' => 'latest_posts_layout',
								'type' => 'select',
								'instructions' => 'Select this section posts layout',
								'column_width' => '',
								'choices' => array (
									'masonry-layout' => 'Masonry',
									'grid-layout' => 'Grid',
									'list-layout' => 'List',
									'classic-layout' => 'Classic List',
								),
								'default_value' => 'masonry-layout',
								'allow_null' => 0,
								'multiple' => 0,
							),
							array (
								'key' => 'field_5332bf88a68a6',
								'label' => 'Insert Ad',
								'name' => 'latest_insert_ad',
								'type' => 'radio',
								'instructions' => 'Select the ad type',
								'column_width' => '',
								'choices' => array (
									'latest_no_ad_option' => 'No Ad',
									'latest_image_ad_option' => 'Image Ad',
									'latest_code_ad_option' => 'Code Ad',
								),
								'other_choice' => 0,
								'save_other_choice' => 0,
								'default_value' => 'latest_no_ad_option',
								'layout' => 'horizontal',
							),
							array (
								'key' => 'field_5332d0dba68a7',
								'label' => 'Image Ad',
								'name' => 'latest_image_ad',
								'type' => 'image',
								'conditional_logic' => array (
									'status' => 1,
									'rules' => array (
										array (
											'field' => 'field_5332bf88a68a6',
											'operator' => '==',
											'value' => 'latest_image_ad_option',
										),
									),
									'allorany' => 'all',
								),
								'column_width' => '',
								'save_format' => 'id',
								'preview_size' => 'full',
								'library' => 'all',
							),
							array (
								'key' => 'field_5332d36ea68a8',
								'label' => 'Image Ad Link',
								'name' => 'latest_image_ad_link',
								'type' => 'text',
								'instructions' => 'Paste the URL where the image ad must link to',
								'conditional_logic' => array (
									'status' => 1,
									'rules' => array (
										array (
											'field' => 'field_5332bf88a68a6',
											'operator' => '==',
											'value' => 'latest_image_ad_option',
										),
									),
									'allorany' => 'all',
								),
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'formatting' => 'none',
								'maxlength' => '',
							),
							array (
								'key' => 'field_5332d407a68a9',
								'label' => 'Code Ad',
								'name' => 'latest_code_ad',
								'type' => 'textarea',
								'instructions' => 'Paste the code of the ad such as Google AdSense',
								'conditional_logic' => array (
									'status' => 1,
									'rules' => array (
										array (
											'field' => 'field_5332bf88a68a6',
											'operator' => '==',
											'value' => 'latest_code_ad_option',
										),
									),
									'allorany' => 'all',
								),
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '',
								'maxlength' => '',
								'rows' => 5,
								'formatting' => 'html',
							),
							array (
								'key' => 'field_535e4bf5e22b7',
								'label' => 'After Post No.',
								'name' => 'latest_after_post_ad',
								'type' => 'number',
								'instructions' => 'Insert the ad after post number',
								'conditional_logic' => array (
									'status' => 1,
									'rules' => array (
										array (
											'field' => 'field_5332bf88a68a6',
											'operator' => '==',
											'value' => 'latest_image_ad_option',
										),
										array (
											'field' => 'field_5332bf88a68a6',
											'operator' => '==',
											'value' => 'latest_code_ad_option',
										),
									),
									'allorany' => 'any',
								),
								'column_width' => '',
								'default_value' => 3,
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'min' => 1,
								'max' => '',
								'step' => 1,
							),
							array (
								'key' => 'field_5332bc592165a',
								'label' => 'Exclude Categories',
								'name' => 'latest_exclude_cats',
								'type' => 'true_false',
								'column_width' => '',
								'message' => 'Click to exclude categories',
								'default_value' => 0,
							),
							array (
								'key' => 'field_532304c924147',
								'label' => 'Select Categories',
								'name' => 'latest_posts_exclude',
								'type' => 'taxonomy',
								'instructions' => 'Select the categories you would like to exclude',
								'conditional_logic' => array (
									'status' => 1,
									'rules' => array (
										array (
											'field' => 'field_5332bc592165a',
											'operator' => '==',
											'value' => '1',
										),
									),
									'allorany' => 'all',
								),
								'column_width' => '',
								'taxonomy' => 'category',
								'field_type' => 'checkbox',
								'allow_null' => 0,
								'load_save_terms' => 0,
								'return_format' => 'object',
								'multiple' => 0,
							),
							array (
								'key' => 'field_53b16728353ca',
								'label' => 'Posts to Show',
								'name' => 'latest_posts_per_page',
								'type' => 'number',
								'instructions' => 'How many posts to show at once',
								'column_width' => '',
								'default_value' => 3,
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'min' => 2,
								'max' => '',
								'step' => 1,
							),
						),
					),
					array (
						'label' => 'Full Width Image',
						'name' => 'full_width_image',
						'display' => 'row',
						'min' => '',
						'max' => '',
						'sub_fields' => array (
							array (
								'key' => 'field_53a950cd20e20',
								'label' => 'Main TItle',
								'name' => 'full_image_main_title',
								'type' => 'text',
								'instructions' => 'Main title for this section',
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'formatting' => 'none',
								'maxlength' => '',
							),
							array (
								'key' => 'field_53a956e820e21',
								'label' => 'Sub Title',
								'name' => 'full_image_sub_title',
								'type' => 'text',
								'instructions' => 'Sub title for this section',
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'formatting' => 'none',
								'maxlength' => '',
							),
							array (
								'key' => 'field_53a95bf76ab14',
								'label' => 'Button Text',
								'name' => 'full_image_button_text',
								'type' => 'text',
								'instructions' => 'Enter button text. Leave blank not to show the button',
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'formatting' => 'none',
								'maxlength' => '',
							),
							array (
								'key' => 'field_53a95c076ab15',
								'label' => 'Button URL',
								'name' => 'full_image_button_url',
								'type' => 'text',
								'instructions' => 'Enter button URL',
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'formatting' => 'none',
								'maxlength' => '',
							),
							array (
								'key' => 'field_53a9570e20e22',
								'label' => 'Upload Image',
								'name' => 'full_image_upload',
								'type' => 'image',
								'column_width' => '',
								'save_format' => 'object',
								'preview_size' => 'thumbnail',
								'library' => 'all',
							),
						),
					),
					array (
						'label' => 'Image Ad',
						'name' => 'image_advertising',
						'display' => 'row',
						'min' => '',
						'max' => '',
						'sub_fields' => array (
							array (
								'key' => 'field_536a6945ce59b',
								'label' => 'Upload Image',
								'name' => 'ad_banner_url',
								'type' => 'image',
								'instructions' => 'Upload the image',
								'column_width' => '',
								'save_format' => 'object',
								'preview_size' => 'thumbnail',
								'library' => 'all',
							),
							array (
								'key' => 'field_536a6969ce59c',
								'label' => 'Image URL',
								'name' => 'ad_banner_link',
								'type' => 'text',
								'instructions' => 'Leave blank to output the image without a link',
								'column_width' => '',
								'default_value' => '',
								'placeholder' => 'http://',
								'prepend' => '',
								'append' => '',
								'formatting' => 'none',
								'maxlength' => '',
							),
							array (
								'key' => 'field_536a69a9ce59d',
								'label' => 'Image Behavior',
								'name' => 'static_image_mode',
								'type' => 'radio',
								'instructions' => 'Select how to open the image',
								'column_width' => '',
								'choices' => array (
									'static_image_regular' => 'Same Window',
									'static_image_banner' => 'New Window',
								),
								'other_choice' => 0,
								'save_other_choice' => 0,
								'default_value' => 'static_image_regular',
								'layout' => 'horizontal',
							),
						),
					),
					array (
						'label' => 'Code Box',
						'name' => 'code_advertising',
						'display' => 'row',
						'min' => '',
						'max' => '',
						'sub_fields' => array (
							array (
								'key' => 'field_53633dc43d25b',
								'label' => 'Code',
								'name' => 'ad_banner_code',
								'type' => 'textarea',
								'instructions' => 'Supports JS, AdSense, HTML or plain text.',
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '',
								'maxlength' => '',
								'rows' => '',
								'formatting' => 'html',
							),
						),
					),
				),
				'button_label' => 'Add Section',
				'min' => '',
				'max' => '',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'page_template',
					'operator' => '==',
					'value' => 'page-composer.php',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'no_box',
			'hide_on_screen' => array (
				0 => 'the_content',
				1 => 'featured_image',
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_page-options',
		'title' => 'Page Options',
		'fields' => array (
			array (
				'key' => 'field_531c52796fb2d',
				'label' => 'Page Sidebar',
				'name' => 'page_sidebar',
				'type' => 'radio',
				'instructions' => 'Enable or Disable sidebar on this page. Disable to use this page full width.',
				'choices' => array (
					'page_sidebar_on' => 'Enable',
					'page_sidebar_off' => 'Disable',
				),
				'other_choice' => 0,
				'save_other_choice' => 0,
				'default_value' => 'page_sidebar_off',
				'layout' => 'horizontal',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'page',
					'order_no' => 0,
					'group_no' => 0,
				),
				array (
					'param' => 'page_template',
					'operator' => '!=',
					'value' => 'page-composer.php',
					'order_no' => 1,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'side',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_page-options-2',
		'title' => 'Page Options',
		'fields' => array (
			array (
				'key' => 'field_536f4b6500284',
				'label' => 'Page Composer Sidebar',
				'name' => 'comp_page_sidebar',
				'type' => 'radio',
				'instructions' => 'Select the page composer sidebar behavior',
				'choices' => array (
					'comp_sidebar_off' => 'No Sidebar',
					'comp_sidebar_page' => 'Whole Page',
					'comp_sidebar_section' => 'Latest Posts section',
				),
				'other_choice' => 0,
				'save_other_choice' => 0,
				'default_value' => 'comp_sidebar_off',
				'layout' => 'vertical',
			),
			array (
				'key' => 'field_536f4c3b9dbe5',
				'label' => 'Posts Page Link',
				'name' => 'comp_posts_page_link',
				'type' => 'radio',
				'instructions' => 'Enable or Disable the link to Posts Page.',
				'choices' => array (
					'comp_posts_page_on' => 'Enable',
					'comp_posts_page_off' => 'Disable',
				),
				'other_choice' => 0,
				'save_other_choice' => 0,
				'default_value' => 'comp_posts_page_off',
				'layout' => 'horizontal',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'page_template',
					'operator' => '==',
					'value' => 'page-composer.php',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'side',
			'layout' => 'default',
			'hide_on_screen' => array (
				0 => 'the_content',
				1 => 'featured_image',
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_post-options',
		'title' => 'Post Options',
		'fields' => array (
			array (
				'key' => 'field_531481b028dad',
				'label' => 'Media Position',
				'name' => 'post_media_position',
				'type' => 'radio',
				'choices' => array (
					'media_full_width' => 'Full Width',
					'media_above_content' => 'Above The Content',
				),
				'other_choice' => 0,
				'save_other_choice' => 0,
				'default_value' => '',
				'layout' => 'vertical',
			),
			array (
				'key' => 'field_53cec351971b7',
				'label' => 'Homepage Slider',
				'name' => 'homepage_slider_add',
				'type' => 'true_false',
				'message' => 'Add this post to homepage slider',
				'default_value' => 0,
			),
			array (
				'key' => 'field_53ad7fb9bd2bb',
				'label' => 'Make Featured',
				'name' => 'featured_post_add',
				'type' => 'true_false',
				'message' => 'Make this post featured',
				'default_value' => 0,
			),
			array (
				'key' => 'field_531c4c5332166',
				'label' => 'Category Slider',
				'name' => 'category_slider_add',
				'type' => 'true_false',
				'message' => 'Add this post to category slider',
				'default_value' => 0,
			),
			array (
				'key' => 'field_531c4bce89731',
				'label' => 'Post	Sidebar',
				'name' => 'post_sidebar',
				'type' => 'radio',
				'choices' => array (
					'post_sidebar_on' => 'Enable',
					'post_sidebar_off' => 'Disable',
				),
				'other_choice' => 0,
				'save_other_choice' => 0,
				'default_value' => 'post_sidebar_on',
				'layout' => 'horizontal',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'post',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'side',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_post-score',
		'title' => 'Post Score',
		'fields' => array (
			array (
				'key' => 'field_531c4deba097f',
				'label' => 'Enable Post Rating',
				'name' => 'enable_rating',
				'type' => 'true_false',
				'message' => 'Turn On the Score',
				'default_value' => 0,
			),
			array (
				'key' => 'field_531c4e58a0980',
				'label' => 'Rating Note',
				'name' => 'rating_note',
				'type' => 'text',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_531c4deba097f',
							'operator' => '==',
							'value' => '1',
						),
					),
					'allorany' => 'all',
				),
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_531c4ed4a0982',
				'label' => 'Rating',
				'name' => 'rating_module',
				'type' => 'repeater',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_531c4deba097f',
							'operator' => '==',
							'value' => '1',
						),
					),
					'allorany' => 'all',
				),
				'sub_fields' => array (
					array (
						'key' => 'field_531c4ef2a0983',
						'label' => 'Label',
						'name' => 'score_label',
						'type' => 'text',
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => '',
					),
					array (
						'key' => 'field_531c4f13a0984',
						'label' => 'Score',
						'name' => 'score_number',
						'type' => 'select',
						'column_width' => '',
						'choices' => array (
							1 => 1,
							2 => 2,
							3 => 3,
							4 => 4,
							5 => 5,
							6 => 6,
							7 => 7,
							8 => 8,
							9 => 9,
							10 => 10,
						),
						'default_value' => 1,
						'allow_null' => 0,
						'multiple' => 0,
					),
				),
				'row_min' => 1,
				'row_limit' => '',
				'layout' => 'table',
				'button_label' => 'Add Score Row',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'post',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
}



/* Add-Ons
 * USING PREMIUN ADD-ONS OUTSIDE THIS THEME IS NOT ALLOWED!!!
 */
function ti_register_fields(){
	include_once('add-ons/acf-gallery/gallery.php');
	include_once('add-ons/acf-repeater/repeater.php');
	include_once('add-ons/acf-flexible-content/flexible-content.php');
}
add_action('acf/register_fields', 'ti_register_fields'); 